/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.cmlc.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.fczx.cmlc.data.dto.vo.CmlcBaseResult;
import com.geoway.fczx.cmlc.data.dto.vo.CommandResult;
import com.geoway.fczx.cmlc.data.property.CmlcProperties;
import com.geoway.fczx.cmlc.enums.ClmcRestApi;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CmlcBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(CmlcBaseHandler.class);
    @Resource
    private RestTemplate clmcFhApiRest;
    @Resource
    private CmlcProperties properties;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public Object forwardClmcRequest(String base, Map<String, Object> params, Map<String, Object> body, String method) {
        if (ObjectUtil.isEmpty((Object)this.properties.getCenterUrl())) {
            log.error("\u4e2d\u79fb\u5e73\u53f0center\u98de\u63a7\u4e2d\u5fc3\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u4e2d\u79fb\u5e73\u53f0center\u98de\u63a7\u4e2d\u5fc3\u5730\u5740\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (HttpMethod.GET.name().equalsIgnoreCase(method)) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = this.properties.getCenterUrl().concat(base).concat("?").concat(this.buildUrlParameters(params));
        ResponseEntity res = this.clmcFhApiRest.exchange(url, HttpMethod.resolve((String)method), request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool(res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u8f6c\u53d1\u4e2d\u79fb\u63a5\u53e3\u8bf7\u6c42{}\u5931\u8d25\uff1a{}", (Object)base, res.getBody());
            throw new RuntimeException("\u8f6c\u53d1\u4e2d\u79fb\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readValue((String)res.getBody(), Object.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> CmlcBaseResult<CommandResult<T>> forwardClmcRequest(ClmcRestApi api, Map<String, Object> params, Object body) {
        if (ObjectUtil.isEmpty((Object)this.properties.getCenterUrl())) {
            log.error("\u4e2d\u79fb\u5e73\u53f0center\u98de\u63a7\u4e2d\u5fc3\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u4e2d\u79fb\u5e73\u53f0center\u98de\u63a7\u4e2d\u5fc3\u5730\u5740\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(api.getMedia());
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = this.properties.getCenterUrl().concat(api.getUri()).concat("?").concat(this.buildUrlParameters(params));
        try {
            ResponseEntity res = this.clmcFhApiRest.exchange(url, api.getMethod(), request, new ParameterizedTypeReference<CmlcBaseResult<CommandResult<T>>>(){}, params);
            boolean flag = this.resolveResultBool(res);
            log.warn("\u8bf7\u6c42\u4e2d\u79fb\u63a5\u53e3\u8bf7\u6c42{}\n\u53c2\u6570\uff1a{}\nbody\uff1a{}\n\u7ed3\u679c : {}", new Object[]{api.getUri(), JSONUtil.toJsonStr(params), JSONUtil.toJsonStr((Object)body), JSONUtil.toJsonStr((Object)res.getBody())});
            Assert.state((boolean)flag, (String)(res.getBody() == null ? "\u672a\u77e5\u9519\u8bef : " + JSONUtil.toJsonStr((Object)res) : ((CmlcBaseResult)res.getBody()).toString()), (Object[])new Object[0]);
            return (CmlcBaseResult)res.getBody();
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4e2d\u79fb\u63a5\u53e3{}\u8bf7\u6c42\u5f02\u5e38\uff1a", (Object)api.getUri(), (Object)e);
            throw new RuntimeException("\u8bf7\u6c42\u4e2d\u79fb\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38 : " + e.getMessage());
        }
    }

    private boolean resolveResultBool(ResponseEntity<?> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            if (res.getBody() instanceof CmlcBaseResult) {
                CmlcBaseResult result = (CmlcBaseResult)BeanUtil.toBean((Object)res.getBody(), CmlcBaseResult.class);
                return Objects.requireNonNull(result).getCode() == 0;
            }
            if (res.getBody() instanceof String && ObjectUtil.isNotEmpty((Object)res.getBody())) {
                int code = JSONUtil.parseObj((Object)res.getBody()).getInt((Object)"code");
                return code == 0;
            }
        }
        return false;
    }

    private String buildUrlParameters(Map<String, Object> map) {
        String parameters = "";
        if (ObjectUtil.isNotEmpty(map)) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!ObjectUtil.isNotEmpty((Object)map.get(key))) continue;
                args.add(key.concat("=").concat(map.get(key).toString()));
            }
            parameters = String.join((CharSequence)"&", args);
        }
        return parameters;
    }

    static {
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

