/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.cmlc.handler;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.cmlc.handler.AbstractCmlcToFczxHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="com.geoway.fczx.cmlc", name={"cmlc-replace-dji-enabled"})
public class CmlcRbSkyHandler {
    private static final Logger log = LoggerFactory.getLogger(CmlcRbSkyHandler.class);
    @Autowired(required=false)
    private AbstractCmlcToFczxHandler convertHandler;

    @RabbitListener(containerFactory="cmlcListenerContainerFactory", queues={"sky.topic.queue.sky-converge"})
    public void receiveFromCmlcQueue(String message) {
        JSONObject json;
        log.info("Received from cmlc queue: " + message);
        if (!ObjectUtil.isNotEmpty((Object)message) || ObjectUtil.isNotEmpty((Object)(json = JSONUtil.parseObj((String)message)).getStr((Object)"method"))) {
            // empty if block
        }
    }
}

