/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.cmlc.restful;

import cn.hutool.core.util.IdUtil;
import com.geoway.fczx.cmlc.data.dto.GatewayCommand;
import com.geoway.fczx.cmlc.data.dto.flightTask.ConditionalTaskCondition;
import com.geoway.fczx.cmlc.data.dto.flightTask.FlightTaskPrepareDTO;
import com.geoway.fczx.cmlc.data.dto.flightTask.FlightTaskUndoCmd;
import com.geoway.fczx.cmlc.data.dto.flyControl.ReturnHomeCmd;
import com.geoway.fczx.cmlc.data.dto.live.LiveStartPushCmd;
import com.geoway.fczx.cmlc.data.dto.live.LiveVideo;
import com.geoway.fczx.cmlc.data.dto.vo.CmlcBaseResult;
import com.geoway.fczx.cmlc.data.dto.vo.CommandResult;
import com.geoway.fczx.cmlc.enums.ClmcRestApi;
import com.geoway.fczx.cmlc.handler.CmlcBaseHandler;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CmlcRestService {
    private static final Logger log = LoggerFactory.getLogger(CmlcRestService.class);
    @Resource
    private CmlcBaseHandler cmlcBaseHandler;

    public OpRes<String> cancelFlight(FlightTaskUndoCmd flightTaskUndoCmd) {
        log.info("\u4e2d\u79fb\u4efb\u52a1\u53d6\u6d88 {}", (Object)flightTaskUndoCmd);
        return this.getStrCmdOpRes(ClmcRestApi.undoTask, flightTaskUndoCmd);
    }

    public OpRes<List<String>> makeFlight(FlightTaskPrepareDTO flightTaskPrepareDTO) {
        log.info("\u4e2d\u79fb\u4efb\u52a1\u6a21\u62df\u8d77\u98de {}", (Object)flightTaskPrepareDTO);
        Integer task_type = flightTaskPrepareDTO.getTask_type();
        ArrayList<String> result = new ArrayList<String>();
        switch (task_type) {
            case 0: {
                flightTaskPrepareDTO.setFlight_id(IdUtil.simpleUUID());
                OpRes<Object> objCmdOpRes = this.getObjCmdOpRes(ClmcRestApi.prepareTask, flightTaskPrepareDTO);
                if (objCmdOpRes.isOpRes()) {
                    result.add(flightTaskPrepareDTO.getFlight_id());
                    return new OpRes("", result, true);
                }
                return new OpRes(objCmdOpRes.getErrorDesc(), null, false);
            }
            case 1: {
                List<Long> taskSeconds = flightTaskPrepareDTO.getTaskSeconds();
                for (Long taskSecond : taskSeconds) {
                    flightTaskPrepareDTO.setFlight_id(IdUtil.simpleUUID());
                    flightTaskPrepareDTO.setExecute_time(taskSecond * 1000L);
                    OpRes<Object> res = this.getObjCmdOpRes(ClmcRestApi.prepareTask, flightTaskPrepareDTO);
                    if (res.isOpRes()) {
                        result.add(flightTaskPrepareDTO.getFlight_id());
                        continue;
                    }
                    OpRes<Object> res1 = this.cancelFlight(flightTaskPrepareDTO, result);
                    if (!res1.isOpRes()) {
                        return new OpRes(res1.getErrorDesc() + "|" + res.getErrorDesc(), null, false);
                    }
                    return new OpRes(res.getErrorDesc(), null, false);
                }
                return new OpRes("", result, true);
            }
            case 2: {
                List<List<Long>> taskPeriods = flightTaskPrepareDTO.getTaskPeriods();
                for (List<Long> taskPeriod : taskPeriods) {
                    flightTaskPrepareDTO.setFlight_id(IdUtil.simpleUUID());
                    ConditionalTaskCondition condition = new ConditionalTaskCondition();
                    condition.setBattery_capacity(flightTaskPrepareDTO.getMinBatteryCapacity());
                    condition.setBegin_time(taskPeriod.get(0) * 1000L);
                    condition.setEnd_time(taskPeriod.get(1) * 1000L);
                    flightTaskPrepareDTO.setConditional_task_condition(condition);
                    OpRes<Object> res = this.getObjCmdOpRes(ClmcRestApi.prepareTask, flightTaskPrepareDTO);
                    if (res.isOpRes()) {
                        result.add(flightTaskPrepareDTO.getFlight_id());
                        continue;
                    }
                    OpRes<Object> res1 = this.cancelFlight(flightTaskPrepareDTO, result);
                    if (!res1.isOpRes()) {
                        return new OpRes(res1.getErrorDesc() + "|" + res.getErrorDesc(), null, false);
                    }
                    return new OpRes(res.getErrorDesc(), null, false);
                }
                return new OpRes("", result, true);
            }
        }
        return new OpRes("\u672a\u77e5\u4efb\u52a1\u7c7b\u578b \uff1a " + task_type, null, false);
    }

    private OpRes<Object> cancelFlight(FlightTaskPrepareDTO flightTaskPrepareDTO, List<String> result) {
        if (!result.isEmpty()) {
            FlightTaskUndoCmd flightTaskUndoCmd = new FlightTaskUndoCmd();
            flightTaskUndoCmd.setGateway_sn(flightTaskPrepareDTO.getGateway_sn());
            flightTaskUndoCmd.setDrone_sn(flightTaskPrepareDTO.getDrone_sn());
            flightTaskUndoCmd.setFlight_ids(result);
            OpRes<String> cancelFlightOpRes = this.cancelFlight(flightTaskUndoCmd);
            if (!cancelFlightOpRes.isOpRes()) {
                return new OpRes(cancelFlightOpRes.getErrorDesc(), null, false);
            }
        }
        return new OpRes("", null, true);
    }

    public OpRes<Object> startLive(LiveStartPushCmd cmd) {
        return this.getObjCmdOpRes(ClmcRestApi.startPush, cmd);
    }

    public OpRes<Boolean> stopLive(LiveVideo liveVideo) {
        return this.getBooleanCmdOpRes(ClmcRestApi.stopPush, liveVideo);
    }

    public OpRes<String> droneReturnHome(ReturnHomeCmd returnHomeCmd) {
        return this.getStrCmdOpRes(ClmcRestApi.return_home, returnHomeCmd);
    }

    public OpRes<String> cancelReturnHome(GatewayCommand gatewayCommand) {
        return this.getStrCmdOpRes(ClmcRestApi.cancel_return_home, gatewayCommand);
    }

    public OpRes<String> flightPause(GatewayCommand gatewayCommand) {
        return this.getStrCmdOpRes(ClmcRestApi.flight_pause, gatewayCommand);
    }

    public OpRes<String> flightRecovery(GatewayCommand gatewayCommand) {
        return this.getStrCmdOpRes(ClmcRestApi.flight_recovery, gatewayCommand);
    }

    @NotNull
    private OpRes<Boolean> getBooleanCmdOpRes(ClmcRestApi restApi, GatewayCommand gatewayCommand) {
        CmlcBaseResult cmlcBaseResult = this.cmlcBaseHandler.forwardClmcRequest(restApi, Collections.emptyMap(), gatewayCommand);
        if (!cmlcBaseResult.isSuccess()) {
            return new OpRes(cmlcBaseResult.getError_msg(), null, false);
        }
        CommandResult commandResult = cmlcBaseResult.getData();
        if (commandResult.isSuccess()) {
            return new OpRes("", (Object)true, true);
        }
        return new OpRes(commandResult.getSpecific_error_msg(), (Object)false, false);
    }

    @NotNull
    private OpRes<String> getStrCmdOpRes(ClmcRestApi restApi, GatewayCommand gatewayCommand) {
        CmlcBaseResult cmlcBaseResult = this.cmlcBaseHandler.forwardClmcRequest(restApi, Collections.emptyMap(), gatewayCommand);
        if (!cmlcBaseResult.isSuccess()) {
            return new OpRes(cmlcBaseResult.getError_msg(), null, false);
        }
        CommandResult commandResult = cmlcBaseResult.getData();
        if (commandResult.isSuccess()) {
            return new OpRes("", null, true);
        }
        return new OpRes(commandResult.getSpecific_error_msg(), null, false);
    }

    @NotNull
    private OpRes<Object> getObjCmdOpRes(ClmcRestApi restApi, GatewayCommand gatewayCommand) {
        CmlcBaseResult cmlcBaseResult = this.cmlcBaseHandler.forwardClmcRequest(restApi, Collections.emptyMap(), gatewayCommand);
        if (!cmlcBaseResult.isSuccess()) {
            return new OpRes(cmlcBaseResult.getError_msg(), null, false);
        }
        CommandResult commandResult = cmlcBaseResult.getData();
        if (commandResult.isSuccess()) {
            return new OpRes("", commandResult.getResult_data(), true);
        }
        return new OpRes(commandResult.getSpecific_error_msg(), null, false);
    }
}

