/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.geoway.fczx.djipri.controller.SkPriBaseController;
import com.geoway.fczx.djipri.data.SkPriTaskParam;
import com.geoway.fczx.djipri.data.SkPriWayline;
import com.geoway.fczx.djipri.restful.DjiPriFhRestService;
import com.geoway.fczx.djipri.services.SkPriProjectService;
import com.geoway.fczx.djipri.services.SkPriWebhookService;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkProject;
import com.geoway.fczx.djsk.enums.DjskNoticeType;
import com.geoway.ue.common.data.page.PageDto;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u53f8\u7a7a\u63a5\u5165\u670d\u52a1"})
@RestController
@RequestMapping(value={"/api/dji-pri/flighthub/v1"})
public class SkPriFlightController
extends SkPriBaseController {
    private static final Logger log = LoggerFactory.getLogger(SkPriFlightController.class);
    @Resource
    private SkPriProjectService priProjectService;
    @Resource
    private SkPriWebhookService priWebhookService;
    @Resource
    private DjiPriFhRestService djiPriFhRestService;

    @Operation(summary="\u521b\u5efamqtt\u6865\u63a5")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/mqtt/bridge"})
    public ResponseEntity<BaseResponse> createMqttBridge(@RequestBody(required=false) Map<String, Object> param) {
        this.priBaseService.createMqttBridge(this.obtainPriProperties(), param);
        return BaseResponse.ok();
    }

    @Operation(summary="hook\u63a5\u53e3\u56de\u8c03")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/call"})
    public ResponseEntity<BaseResponse> allMethodCall(@RequestBody(required=false) Map<String, Object> param) {
        DjskNoticeType type;
        log.info("\u63a5\u6536\u5927\u7586\u53f8\u7a7a\u79c1\u6709\u7248\u6570\u636ebody{}", (Object)JSONUtil.toJsonStr(param));
        if (param != null && param.containsKey("notify_type") && ObjectUtil.notEqual((Object)((Object)(type = DjskNoticeType.find((String)param.get("notify_type")))), (Object)((Object)DjskNoticeType.unknown))) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                Object data = objectMapper.readValue(JSONUtil.toJsonStr(param), type.getArgClass());
                ReflectUtil.invoke((Object)this.priWebhookService, (String)type.getMethod(), (Object[])new Object[]{data});
                return BaseResponse.ok();
            }
            catch (Exception e) {
                log.error("\u63a5\u6536\u6570\u636e{}\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr(param), (Object)e);
                return BaseResponse.error((String)"\u63a5\u6536\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return BaseResponse.error((String)"\u672a\u77e5\u6d88\u606f\u901a\u77e5");
    }

    @Operation(summary="\u83b7\u53d6\u9879\u76ee\u5217\u8868")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/project/list"})
    public ResponseEntity<BaseResponse> getProjectList() {
        SkPageData<SkProject> data = this.priProjectService.getPageOrgProjects(this.obtainPriProperties(), new PageDto());
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u540c\u6b65\u53f8\u7a7a\u8bbe\u5907", description="\u5c06\u5927\u7586\u53f8\u7a7a2\u6307\u5b9a\u7ec4\u7ec7\u8bbe\u5907\u5168\u90e8\u83b7\u53d6\u5e76\u540c\u6b65\u81f3\u8702\u5de2")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/sync/devices"})
    public ResponseEntity<BaseResponse> syncOrganDevices() {
        boolean flag = this.priProjectService.syncOrganDevices(this.obtainPriProperties());
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u8bbe\u5907\u5217\u8868\u5931\u8d25");
    }

    @Operation(summary="\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6", description="\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u81f3\u5927\u7586\u53f8\u7a7a2")
    @ApiImplicitParam(name="withNotice", value="\u662f\u5426\u540c\u6b65\u53d1\u9001\u6d88\u606f\u901a\u77e5", required=true)
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/upload/wayline"})
    public ResponseEntity<BaseResponse> uploadWayline(@RequestPart MultipartFile file, Boolean withNotice) {
        if (ObjectUtil.notEqual((Object)"kmz", (Object)FileUtil.getSuffix((String)file.getOriginalFilename()))) {
            return BaseResponse.error((String)"\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u7c7b\u578b\u7684\u822a\u7ebf\u6587\u4ef6");
        }
        OpRes<SkPriWayline> opRes = this.djiPriFhRestService.uploadWayline(this.obtainPriProperties(), null, file, withNotice);
        return opRes.isOpRes() ? ObjectResponse.ok((Object)((SkPriWayline)opRes.getData()).getId()) : BaseResponse.error((String)opRes.getErrorDesc());
    }

    @Operation(summary="\u540c\u6b65\u822a\u7ebf\u6587\u4ef6", description="\u540c\u6b65\u5927\u7586\u53f8\u7a7a2\u822a\u7ebf\u6587\u4ef6\u81f3\u8702\u5de2")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/sync/wayline"})
    public ResponseEntity<BaseResponse> syncWayline(@RequestParam String waylineId, @RequestParam String projectId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{waylineId, projectId})) {
            SkPriWayline wayline = this.djiPriFhRestService.getWaylineFile(this.obtainPriProperties(), projectId, waylineId);
            if (wayline != null && ObjectUtil.isNotEmpty((Object)wayline.getId())) {
                boolean flag = this.priBaseService.saveWaylineInfo(wayline);
                return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u822a\u7ebf\u6587\u4ef6\u5931\u8d25");
            }
            return BaseResponse.error((String)"\u53f8\u7a7a\u79c1\u6709\u7248\u672a\u627e\u5230\u822a\u7ebf\u4fe1\u606f");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @Operation(summary="\u540c\u6b65\u8d77\u98de\u4efb\u52a1", description="\u540c\u6b65\u5927\u7586\u53f8\u7a7a2\u4e00\u952e\u8d77\u98de\u4efb\u52a1")
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/sync/takeoff"})
    public ResponseEntity<BaseResponse> syncTakeOffTask(@RequestParam String flightId, @RequestParam String projectId) {
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{flightId, projectId})) {
            return BaseResponse.error((String)"\u6682\u672a\u5b9e\u73b0");
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @Operation(summary="\u4e0b\u53d1\u822a\u7ebf\u4efb\u52a1", description="\u4e0b\u53d1\u5927\u7586\u53f8\u7a7a2\u822a\u7ebf\u4efb\u52a1")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/deliver/task"})
    public ResponseEntity<BaseResponse> deliverTask(@RequestBody SkPriTaskParam param) {
        if (param != null && ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getProjectUuid(), param.getSn(), param.getWaylineUuid()})) {
            JSONObject meta = new JSONObject();
            meta.putOpt("rthAltitude", (Object)param.getRthAltitude());
            meta.putOpt("outOfControlAction", (Object)param.obtainOutOfControl());
            OpRes<List<String>> data = this.djiPriFhRestService.makeFlightNow(this.obtainPriProperties(), param, meta);
            return ObjectResponse.ok(data);
        }
        return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    @Operation(summary="\u83b7\u53d6\u76f4\u64ad\u80fd\u529b", description="\u83b7\u53d6\u63a5\u5165\u5927\u7586\u53f8\u7a7a2\u8bbe\u5907\u7684\u76f4\u64ad\u80fd\u529b")
    @ApiImplicitParam(name="deviceSn", value="\u8bbe\u5907SN\u7801")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/video/capacity"})
    public ResponseEntity<BaseResponse> getVideoCapacity(@RequestParam(required=false) String deviceSn) {
        OpRes<List<?>> opRes = this.djiPriFhRestService.getVideoCapacity(this.obtainPriProperties(), null, deviceSn);
        return opRes.isOpRes() ? ObjectResponse.ok((Object)opRes.getData()) : BaseResponse.error((String)opRes.getErrorDesc());
    }

    @Operation(summary="\u83b7\u53d6\u5a92\u4f53\u6587\u4ef6")
    @ApiImplicitParam(name="objectKey", value="\u662f\u5426\u540c\u6b65\u53d1\u9001\u6d88\u606f\u901a\u77e5", required=true)
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/obtain/media"})
    public ResponseEntity<BaseResponse> getMediaFile(@RequestParam String objectKey) {
        OpRes<String> opRes = this.djiPriFhRestService.getFile(this.obtainPriProperties(), objectKey);
        return opRes.isOpRes() ? ObjectResponse.ok((Object)opRes.getData()) : BaseResponse.error((String)opRes.getErrorDesc());
    }
}

