/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.controller;

import com.geoway.fczx.djipri.DjiPriFlighthubApp;
import com.geoway.fczx.djipri.controller.SkPriBaseController;
import com.geoway.fczx.djipri.data.SkLiveInfo;
import com.geoway.fczx.djipri.data.SkPriConverter;
import com.geoway.fczx.djipri.data.SkSwitchConverter;
import com.geoway.fczx.djipri.services.SkPriLiveService;
import com.geoway.fczx.djsk.data.SkConverterState;
import com.geoway.fczx.djsk.data.SkDeviceCamera;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u76f4\u64ad\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DjiPriFlighthubApp.class})
@RequestMapping(value={"/api/dji-pri/live/v1"})
public class SkPriStreamController
extends SkPriBaseController {
    @Resource
    private SkPriLiveService priLiveService;

    @Operation(summary="\u5f00\u542f\u76f4\u64ad\u63a8\u6d41")
    @ApiOperationSupport(order=1, ignoreParameters={"lensType", "cameraPosition"})
    @PostMapping(value={"/start"})
    public ResponseEntity<BaseResponse> startLive(@RequestBody SkDeviceCamera param) {
        SkLiveInfo data = this.priLiveService.startLive(this.obtainPriProperties(), param);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u5f00\u59cb\u7801\u6d41\u8f6c\u53d1")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/converter/create"})
    public ResponseEntity<BaseResponse> createConverter(@RequestBody SkPriConverter param) {
        SkConverterState data = this.priLiveService.createConverter(this.obtainPriProperties(), param);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u542f\u505c\u7801\u6d41\u8f6c\u53d1")
    @ApiOperationSupport(order=3)
    @PutMapping(value={"/{convertId}/switch"})
    public ResponseEntity<BaseResponse> switchConverter(@PathVariable String convertId, @RequestBody SkSwitchConverter param) {
        param.setConvertId(convertId);
        boolean flag = this.priLiveService.switchConverter(this.obtainPriProperties(), param);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u542f\u505c\u7801\u6d41\u8f6c\u53d1\u5931\u8d25");
    }

    @Operation(summary="\u83b7\u53d6\u8f6c\u53d1\u5217\u8868")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/converter"})
    public ResponseEntity<BaseResponse> getConverter() {
        SkPageData<SkPriConverter> data = this.priLiveService.getConverter(this.obtainPriProperties());
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u5220\u9664\u7801\u6d41\u8f6c\u53d1")
    @ApiOperationSupport(order=5)
    @DeleteMapping(value={"/{convertId}"})
    public ResponseEntity<BaseResponse> deleteConverter(@PathVariable String convertId) {
        boolean flag = this.priLiveService.deleteConverter(this.obtainPriProperties(), convertId);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u7801\u6d41\u8f6c\u53d1\u5931\u8d25");
    }
}

