/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.djipri.DjiPriFlighthubApp;
import com.geoway.fczx.djipri.controller.SkPriBaseController;
import com.geoway.fczx.djipri.data.SkPriTaskDetail;
import com.geoway.fczx.djipri.data.SkPriTaskParam;
import com.geoway.fczx.djipri.services.SkPriTaskService;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTrack;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u4efb\u52a1\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DjiPriFlighthubApp.class})
@RequestMapping(value={"/api/dji-pri/task/v1"})
public class SkPriTaskController
extends SkPriBaseController {
    @Resource
    private SkPriTaskService priTaskService;

    @Operation(summary="\u521b\u5efa\u98de\u884c\u4efb\u52a1")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/create"})
    public ResponseEntity<BaseResponse> createFlightTask(@RequestBody SkPriTaskParam param) {
        SkResultData data = this.priTaskService.createFlightTask(this.obtainPriProperties(), param);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u66f4\u65b0\u4efb\u52a1\u72b6\u6001")
    @ApiOperationSupport(order=2)
    @PutMapping(value={"/{taskId}/status"})
    public ResponseEntity<BaseResponse> updateTaskStatus(@PathVariable String taskId, @RequestParam String status) {
        boolean flag = this.priTaskService.updateTaskStatus(this.obtainPriProperties(), null, taskId, status);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25");
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/{taskId}/detail"})
    public ResponseEntity<BaseResponse> obtainTaskDetail(@PathVariable String taskId) {
        SkPriTaskDetail data = this.priTaskService.obtainTaskDetail(this.obtainPriProperties(), null, taskId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u8bbe\u5907SN", required=true), @ApiImplicitParam(name="name", value="\u4efb\u52a1\u540d\u79f0"), @ApiImplicitParam(name="beginAt", value="\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u6233", required=true, dataTypeClass=Long.class), @ApiImplicitParam(name="endAt", value="\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\u6233", required=true, dataTypeClass=Long.class), @ApiImplicitParam(name="taskType", value="\u4efb\u52a1\u7c7b\u578b"), @ApiImplicitParam(name="status", value="\u4efb\u52a1\u72b6\u6001\u6570\u7ec4")})
    @ApiOperationSupport(order=4, ignoreParameters={"param"})
    @GetMapping(value={"/list"})
    public ResponseEntity<BaseResponse> obtainTaskList(@RequestParam Map<String, Object> param, Long beginAt, Long endAt, String[] status) {
        param.put("beginAt", beginAt);
        param.put("endAt", endAt);
        if (ObjectUtil.isNotEmpty((Object)status)) {
            param.put("status", Arrays.asList(status));
        }
        SkPageData<SkPriTaskDetail> data = this.priTaskService.obtainTaskList(this.obtainPriProperties(), null, BeanUtil.beanToMap(param, (boolean)true, (boolean)true));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u8d44\u6e90")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/{taskId}/media"})
    public ResponseEntity<BaseResponse> obtainTaskFiles(@PathVariable String taskId) {
        SkResultData data = this.priTaskService.obtainTaskFiles(this.obtainPriProperties(), null, taskId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u8f68\u8ff9")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/{taskId}/track"})
    public ResponseEntity<BaseResponse> obtainTaskTrack(@PathVariable String taskId) {
        SkTrack data = this.priTaskService.obtainTaskTrack(this.obtainPriProperties(), null, taskId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u6587\u4ef6\u5730\u5740")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/obs/url"})
    public ResponseEntity<BaseResponse> obtainObsFile(@RequestParam String objectKey) {
        String data = this.priTaskService.obtainObsFile(this.obtainPriProperties(), null, objectKey);
        return ObjectResponse.ok((Object)data);
    }
}

