/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.handler;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.enmus.DjiPriRestApi;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DjiPriBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(DjiPriBaseHandler.class);
    @Resource
    private RestTemplate djiFhApiRest;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public <T> T forwardDjiRequest(DjiPriProperties serverProperties, DjiPriRestApi api, Map<String, Object> params, Map<String, Object> body) {
        String server = serverProperties.getApiUrl();
        if (ObjectUtil.isEmpty((Object)server)) {
            log.error("\u5927\u7586\u53f8\u7a7a2\u79c1\u6709\u7248\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u5927\u7586\u53f8\u7a7a2\u79c1\u6709\u7248\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("X-Request-Id", IdUtil.fastSimpleUUID());
        headers.set("X-Language", serverProperties.getLanguage());
        headers.set("X-User-Token", serverProperties.getOrganKey());
        if (api.isWithProj()) {
            headers.set("X-Project-Uuid", serverProperties.getProjectUuid());
        }
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = server.concat(api.getUri());
        String urlArgs = DjiPriBaseHandler.buildUrlParameters(params);
        if (ObjectUtil.isNotEmpty((Object)urlArgs)) {
            url = url.concat("?").concat(urlArgs);
        }
        ResponseEntity res = this.djiFhApiRest.exchange(url, api.getMethod(), request, String.class, params);
        JSONObject resData = JSONUtil.parseObj((String)((String)res.getBody()));
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u8f6c\u53d1\u5927\u7586\u53f8\u7a7a2\u79c1\u6709\u7248\u63a5\u53e3\u8bf7\u6c42{}\u5931\u8d25\uff1a{}", (Object)api.getUri(), res.getBody());
            throw new RuntimeException(resData.getStr((Object)"message"));
        }
        try {
            if (ObjectUtil.isNotEmpty((Object)resData.getObj((Object)"data"))) {
                if (api.getClazz() == String.class) {
                    return (T)resData.getStr((Object)"data");
                }
                return (T)objectMapper.readValue(resData.getJSONObject((Object)"data").toString(), api.getClazz());
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5927\u7586\u53f8\u7a7a\u79c1\u6709\u7248\u8bf7\u6c42{}\u89e3\u6790\u7ed3\u679c\u5931\u8d25", (Object)api.getUri(), (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u5927\u7586\u53f8\u7a7a\u79c1\u6709\u7248\u8bf7\u6c42\u89e3\u6790\u7ed3\u679c\u5931\u8d25");
        }
    }

    public static String buildUrlParameters(Map<String, Object> map) {
        String parameters = "";
        if (ObjectUtil.isNotEmpty(map)) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!ObjectUtil.isNotEmpty((Object)map.get(key))) continue;
                args.add(key.concat("=").concat(map.get(key).toString()));
            }
            parameters = String.join((CharSequence)"&", args);
        }
        return parameters;
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code") == 0;
        }
        return false;
    }

    static {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

