/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.restful;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.geoway.fczx.djipri.data.SkLiveInfo;
import com.geoway.fczx.djipri.data.SkPriTaskDetail;
import com.geoway.fczx.djipri.data.SkPriTaskParam;
import com.geoway.fczx.djipri.data.SkPriWayline;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.services.SkPriDeviceService;
import com.geoway.fczx.djipri.services.SkPriFileService;
import com.geoway.fczx.djipri.services.SkPriLiveService;
import com.geoway.fczx.djipri.services.SkPriProjectService;
import com.geoway.fczx.djipri.services.SkPriTaskService;
import com.geoway.fczx.djipri.services.SkPriWaylineService;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkDeviceCamera;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTaskCmd;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.data.SkWaylineFile;
import com.geoway.fczx.djsk.data.call.SkMediaFileInfo;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DjiPriFhRestService {
    private static final Logger log = LoggerFactory.getLogger(DjiPriFhRestService.class);
    @Resource
    private SkPriProjectService priProjectService;
    @Resource
    private SkPriWaylineService priWaylineService;
    @Resource
    private SkPriDeviceService priDeviceService;
    @Resource
    private SkPriLiveService priLiveService;
    @Resource
    private SkPriTaskService priTaskService;
    @Resource
    private SkPriFileService priFileService;

    public OpRes<Boolean> hangUpJob(DjiPriProperties properties, String jobId, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", (Object)false, false);
        }
        boolean flag = this.priTaskService.updateTaskStatus(properties, projectId, jobId, "suspended");
        return new OpRes(!flag ? "\u4efb\u52a1\u4e00\u952e\u6302\u8d77\u5931\u8d25" : null, (Object)flag, flag);
    }

    public OpRes<Boolean> cancelHangUpJob(DjiPriProperties properties, String jobId, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", (Object)false, false);
        }
        boolean flag = this.priTaskService.updateTaskStatus(properties, projectId, jobId, "restored");
        return new OpRes(!flag ? "\u4efb\u52a1\u4e00\u952e\u6302\u8d77\u5931\u8d25" : null, (Object)flag, flag);
    }

    public String droneReturnHome(DjiPriProperties properties, String deviceSn, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.priDeviceService.executeCommand(properties, new SkTaskCmd("return_home", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25";
    }

    public String droneCancelHome(DjiPriProperties properties, String deviceSn, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.priDeviceService.executeCommand(properties, new SkTaskCmd("return_home_cancel", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u53d6\u6d88\u8fd4\u822a\u5931\u8d25";
    }

    public String flightPause(DjiPriProperties properties, String deviceSn, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.priDeviceService.executeCommand(properties, new SkTaskCmd("flighttask_pause", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u6682\u505c\u98de\u884c\u5931\u8d25";
    }

    public String flightRecovery(DjiPriProperties properties, String deviceSn, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.priDeviceService.executeCommand(properties, new SkTaskCmd("flighttask_recovery", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u6062\u590d\u98de\u884c\u5931\u8d25";
    }

    public OpRes<SkPriWayline> uploadWayline(DjiPriProperties properties, String file, Boolean withNotice) {
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        SkToken token = this.priProjectService.obtainProjectToken(properties, null);
        if (ObjectUtil.isEmpty((Object)token)) {
            return new OpRes("\u83b7\u53d6\u4e34\u65f6\u4e0a\u4f20\u51ed\u8bc1\u5931\u8d25", null, false);
        }
        try {
            String filename = FileUtil.getName((String)file);
            String base = Path.joinPath((String)"/", (String[])new String[]{token.getObjectKeyPrefix(), IdUtil.randomUUID()});
            String objectKey = Path.joinPath((String)"/", (String[])new String[]{base, filename});
            boolean flag = this.uploadFileToOss(token, objectKey, file);
            if (flag) {
                SkPriWayline wayline;
                SkWaylineFile waylineFile = new SkWaylineFile(FileUtil.getPrefix((String)filename), objectKey);
                log.debug("{}", (Object)JSONUtil.toJsonPrettyStr((Object)waylineFile));
                if (BooleanUtil.isTrue((Boolean)withNotice) && (wayline = this.priWaylineService.callProjectWayline(properties, null, waylineFile)) != null && ObjectUtil.isNotEmpty((Object)wayline.getId())) {
                    wayline.setObjectKey(objectKey);
                    return new OpRes(null, (Object)wayline, true);
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        return new OpRes("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFileToOss(SkToken token, String objectKey, String file) {
        if (ObjectUtil.equal((Object)token.getProvider(), (Object)"minio")) {
            AmazonS3 s3 = null;
            try {
                s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(token.getCredentials().getAccessKeyId(), token.getCredentials().getAccessKeySecret(), token.getCredentials().getSecurityToken())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(token.getEndpoint(), token.getRegion()))).build();
                s3.putObject(token.getBucket(), objectKey, FileUtil.file((String)file));
            }
            finally {
                if (s3 != null) {
                    s3.shutdown();
                }
            }
            return true;
        }
        if (ObjectUtil.equal((Object)token.getProvider(), (Object)"aliyun")) {
            OSS ossClient = null;
            try {
                ossClient = new OSSClientBuilder().build(token.getEndpoint(), token.getCredentials().getAccessKeyId(), token.getCredentials().getAccessKeySecret(), token.getCredentials().getSecurityToken());
                ossClient.putObject(token.getBucket(), objectKey, (InputStream)FileUtil.getInputStream((String)file));
            }
            finally {
                if (ossClient != null) {
                    ossClient.shutdown();
                }
            }
            return true;
        }
        return false;
    }

    public OpRes<String> getFile(DjiPriProperties properties, String objectKey) {
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        SkToken token = this.priProjectService.obtainProjectToken(properties, null);
        if (ObjectUtil.isEmpty((Object)token)) {
            return new OpRes("\u83b7\u53d6\u4e34\u65f6\u4e0a\u4f20\u51ed\u8bc1\u5931\u8d25", null, false);
        }
        URL url = this.obtainFileToOss(token, objectKey, properties.getExpireTime());
        return new OpRes(ObjectUtil.isEmpty((Object)url) ? "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25" : null, (Object)(ObjectUtil.isEmpty((Object)url) ? null : url.toString()), ObjectUtil.isNotEmpty((Object)url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL obtainFileToOss(SkToken token, String objectKey, long expire) {
        if (ObjectUtil.equal((Object)token.getProvider(), (Object)"minio")) {
            AmazonS3 s3 = null;
            try {
                s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicSessionCredentials(token.getCredentials().getAccessKeyId(), token.getCredentials().getAccessKeySecret(), token.getCredentials().getSecurityToken())))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(token.getEndpoint(), token.getRegion()))).build();
                URL uRL = s3.generatePresignedUrl(token.getBucket(), objectKey, new Date(System.currentTimeMillis() + expire * 1000L));
                return uRL;
            }
            finally {
                if (s3 != null) {
                    s3.shutdown();
                }
            }
        }
        if (ObjectUtil.equal((Object)token.getProvider(), (Object)"aliyun")) {
            OSS ossClient = null;
            try {
                ossClient = new OSSClientBuilder().build(token.getEndpoint(), token.getCredentials().getAccessKeyId(), token.getCredentials().getAccessKeySecret(), token.getCredentials().getSecurityToken());
                URL uRL = ossClient.generatePresignedUrl(token.getBucket(), objectKey, new Date(System.currentTimeMillis() + expire * 1000L));
                return uRL;
            }
            finally {
                if (ossClient != null) {
                    ossClient.shutdown();
                }
            }
        }
        return null;
    }

    public OpRes<List<String>> makeFlightNow(DjiPriProperties properties, SkPriTaskParam param, JSONObject metadata) {
        log.info("param={}", (Object)JSONUtil.toJsonStr((Object)BeanUtil.beanToMap((Object)param, (boolean)true, (boolean)true)));
        properties.setProjectUuid(param.getProjectUuid());
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        SkResultData res = this.priTaskService.createFlightTask(properties, param);
        if (res != null && ObjectUtil.isNotEmpty((Object)res.getTaskUuid())) {
            SkPageData<SkPriTaskDetail> list;
            ThreadUtil.safeSleep((long)1000L);
            if (ObjectUtil.contains(Arrays.asList("continuous", "recurring"), (Object)param.getTaskType()) && (list = this.priTaskService.obtainTaskList(properties, null, param.convertListParam())) != null && ObjectUtil.isNotEmpty(list.getList())) {
                ArrayList<String> idList = new ArrayList<String>();
                list.getList().forEach(e -> {
                    if (ObjectUtil.isNotEmpty((Object)e.getUuid())) {
                        idList.add(e.getUuid());
                    }
                });
                this.priProjectService.deliverTaskAfter(idList, list.getList(), metadata);
                return new OpRes(null, idList, true);
            }
            SkPriTaskDetail detail = this.priTaskService.obtainTaskDetail(properties, null, res.getTaskUuid());
            detail.setTaskUuid(res.getTaskUuid());
            this.priProjectService.deliverTaskAfter(Collections.singletonList(res.getTaskUuid()), Collections.singletonList(detail), metadata);
            return new OpRes(null, Collections.singletonList(res.getTaskUuid()), true);
        }
        return new OpRes("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpRes<SkPriWayline> uploadWayline(DjiPriProperties properties, String projectId, MultipartFile file, Boolean withNotice) {
        String output = file.getOriginalFilename();
        try {
            output = Path.joinPath((String)File.separator, (String[])new String[]{System.getProperty("user.dir"), "waylines", output});
            if (!FileUtil.exist((String)output)) {
                FileUtil.mkdir((String)new File(output).getParent());
                FileUtil.newFile((String)output);
            }
            FileUtil.writeBytes((byte[])file.getBytes(), (String)output);
            if (ObjectUtil.isNotEmpty((Object)projectId)) {
                properties.setProjectUuid(projectId);
            }
            OpRes<SkPriWayline> opRes = this.uploadWayline(properties, output, withNotice);
            return opRes;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            FileUtil.del((String)output);
        }
        return new OpRes("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", null, false);
    }

    private boolean checkDjiOrganInfo(DjiPriProperties properties) {
        if (properties == null) {
            log.error("\u5927\u7586\u53f8\u7a7a\u914d\u7f6e\u4fe1\u606f\u6709\u8bef");
            return false;
        }
        if (ObjectUtil.isEmpty((Object)properties.getOrganKey())) {
            log.error("\u5927\u7586\u53f8\u7a7a\u7ec4\u7ec7\u5bc6\u94a5\u672a\u83b7\u53d6");
            return false;
        }
        if (ObjectUtil.isEmpty((Object)properties.getProjectUuid())) {
            log.error("\u5927\u7586\u53f8\u7a7a\u9879\u76eeuuid\u672a\u83b7\u53d6");
            return false;
        }
        return true;
    }

    public OpRes<List<?>> getVideoCapacity(DjiPriProperties properties, String projectId, String deviceSn) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        if (!this.checkDjiOrganInfo(properties)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        SkDevice device = this.priDeviceService.getDeviceState(properties, projectId, deviceSn);
        if (device != null && ObjectUtil.isNotEmpty((Object)device.getDeviceState())) {
            JSONArray array = (JSONArray)device.getDeviceState().getByPath("live_capacity.device_list", JSONArray.class);
            ArrayList resList = new ArrayList();
            array.toList(JSONObject.class).forEach(json -> {
                JSONArray cameras = new JSONArray();
                JSONObject data = new JSONObject();
                data.putOpt("sn", (Object)json.getStr((Object)"sn"));
                data.putOpt("cameras_list", (Object)cameras);
                data.putOpt("source", (Object)"dji_pri");
                json.getJSONArray((Object)"camera_list").toList(JSONObject.class).forEach(e -> {
                    JSONObject camera = new JSONObject();
                    JSONObject video = new JSONObject();
                    video.putOpt("type", e.getByPath("video_list[0].video_type"));
                    video.putOpt("index", e.getByPath("video_list[0].video_index"));
                    video.putOpt("switch_video_types", e.getByPath("video_list[0].switchable_video_types"));
                    camera.putOpt("index", (Object)e.getStr((Object)"camera_index"));
                    camera.putOpt("name", (Object)("Camera" + e.getStr((Object)"camera_index")));
                    camera.putOpt("videos_list", Collections.singletonList(video));
                    cameras.add((Object)camera);
                });
                resList.add(data);
            });
            return new OpRes(null, resList, true);
        }
        return new OpRes("\u672a\u627e\u5230\u76f8\u5173\u8bbe\u5907\u8d1f\u8f7d\u4fe1\u606f", null, false);
    }

    public OpRes<Object> startLive(DjiPriProperties properties, SkDeviceCamera camera) {
        SkLiveInfo live = this.priLiveService.startLive(properties, camera);
        if (ObjectUtil.isNotEmpty((Object)live)) {
            JSONObject json = new JSONObject();
            json.putOpt("rtc_pull_url", (Object)live.getUrl());
            json.putOpt("provider", (Object)properties.getLiveProvider());
            return new OpRes(null, (Object)MapUtil.of((Object)"channel_info", (Object)json), true);
        }
        return new OpRes("\u5f00\u542f\u76f4\u64ad\u63a8\u6d41\u5931\u8d25", null, false);
    }

    public SkPriWayline getWaylineFile(DjiPriProperties properties, String projectId, String waylineId) {
        SkPriWayline wayline = this.priWaylineService.getWaylineDetail(properties, projectId, waylineId);
        if (wayline == null || ObjectUtil.isEmpty((Object)wayline.getId())) {
            log.error("\u53f8\u7a7a\u79c1\u6709\u7248{}\u672a\u627e\u5230\u9879\u76ee[{}]\u822a\u7ebf\u4fe1\u606f{}", new Object[]{properties.getApiUrl(), projectId, waylineId});
        } else {
            wayline.setProjectId(projectId);
            wayline.setSameStorage(properties.getSameStorage());
        }
        return wayline;
    }

    public void syncTaskFileUpload(DjiPriProperties properties, String flightId) {
        SkResultData skResult;
        if (!BooleanUtil.isTrue((Boolean)properties.getSameStorage()) && (skResult = this.priTaskService.obtainTaskFiles(properties, null, flightId)) != null && ObjectUtil.isNotEmpty(skResult.getList())) {
            skResult.getList().forEach(e -> {
                JSONObject json = new JSONObject(e);
                if (ObjectUtil.isNotEmpty((Object)json.getStr((Object)"original_url"))) {
                    SkMediaFileInfo fileInfo = new SkMediaFileInfo();
                    fileInfo.setDownloadUrl(json.getStr((Object)"original_url"));
                    this.priFileService.syncTaskFileUpload(fileInfo);
                }
            });
        }
    }

    public void syncTaskFileUpload(DjiPriProperties properties, Set<String> objectKeys) {
        if (!BooleanUtil.isTrue((Boolean)properties.getSameStorage())) {
            objectKeys.forEach(objectKey -> {
                String url;
                if (ObjectUtil.isNotEmpty((Object)objectKey) && ObjectUtil.isNotEmpty((Object)(url = this.priTaskService.obtainObsFile(properties, null, (String)objectKey)))) {
                    SkMediaFileInfo fileInfo = new SkMediaFileInfo();
                    fileInfo.setDownloadUrl(url);
                    fileInfo.setObjectKey((String)objectKey);
                    this.priFileService.syncTaskFileUpload(fileInfo);
                }
            });
        }
    }
}

