/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.djipri.data.SkPriWayline;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.handler.AbstractDjiPriToFczxHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SkPriBaseService {
    @Resource
    private Environment environment;
    @Resource
    private DjiPriProperties properties;
    @Autowired(required=false)
    private AbstractDjiPriToFczxHandler priConvertHandler;
    private static final String MQTT_SERVER = "com.geoway.fczx.mqtt.server-url";
    private static final String BRIDGE_URL = "/bridges/v1/resources";

    public DjiPriProperties obtainPriProperties() {
        if (this.priConvertHandler != null) {
            return this.priConvertHandler.obtainPriProperties();
        }
        return this.properties;
    }

    public DjiPriProperties obtainPriPropertiesByJob(String flightId) {
        if (this.priConvertHandler != null) {
            return this.priConvertHandler.obtainPriPropertiesByJob(flightId);
        }
        return null;
    }

    public boolean saveWaylineInfo(SkPriWayline wayline) {
        if (this.priConvertHandler != null) {
            return this.priConvertHandler.saveWaylineInfo(wayline);
        }
        return false;
    }

    public boolean createMqttBridge(DjiPriProperties properties, Map<String, Object> param) {
        if (ObjectUtil.isEmpty(param)) {
            param = new HashMap<String, Object>();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("username", properties.getBridgeUser());
            config.put("password", properties.getBridgePass());
            config.put("proto_ver", "mqttv4");
            config.put("address", ((String)this.environment.getProperty(MQTT_SERVER, String.class)).replace("tcp//", ""));
            param.put("clientid", "fh2-pri-bridge2");
            param.put("config", config);
        }
        String port = properties.getApiUrl().substring(properties.getApiUrl().lastIndexOf(":") + 1);
        String url = properties.getApiUrl().replace(port, properties.getBridgePort()).concat(BRIDGE_URL);
        HttpUtil.post((String)url, (String)JSONUtil.toJsonStr(param));
        return false;
    }
}

