/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.handler.AbstractDjiPriToFczxHandler;
import com.geoway.fczx.djipri.services.SkPriTaskService;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.call.SkMediaFileInfo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkPriFileService {
    private static final Logger log = LoggerFactory.getLogger(SkPriFileService.class);
    @Autowired(required=false)
    private AbstractDjiPriToFczxHandler priConvertHandler;
    @Resource
    private SkPriTaskService priTaskService;

    public void syncFileUpload(DjiPriProperties properties, String flightId, SkMediaFileInfo file) {
        SkResultData skResult;
        if (!BooleanUtil.isTrue((Boolean)properties.getSameStorage()) && (skResult = this.priTaskService.obtainTaskFiles(properties, properties.getProjectUuid(), flightId)) != null && ObjectUtil.isNotEmpty(skResult.getList())) {
            skResult.getList().forEach(e -> {
                JSONObject media = new JSONObject(e);
                if (ObjectUtil.equal((Object)media.get((Object)"name"), (Object)file.getName())) {
                    file.setDownloadUrl(media.getStr((Object)"original_url"));
                    this.priConvertHandler.syncDjiPriMediaFile(file);
                }
            });
        }
    }

    public void syncTaskFileUpload(SkMediaFileInfo file) {
        this.priConvertHandler.syncDjiPriMediaFile(file);
    }
}

