/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.fczx.djipri.data.SkLiveInfo;
import com.geoway.fczx.djipri.data.SkPriConverter;
import com.geoway.fczx.djipri.data.SkSwitchConverter;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.enmus.DjiPriRestApi;
import com.geoway.fczx.djipri.handler.DjiPriBaseHandler;
import com.geoway.fczx.djsk.data.SkConverterState;
import com.geoway.fczx.djsk.data.SkDeviceCamera;
import com.geoway.fczx.djsk.data.SkPageData;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SkPriLiveService {
    private static final Logger log = LoggerFactory.getLogger(SkPriLiveService.class);
    @Resource
    private DjiPriBaseHandler priBaseHandler;

    public SkLiveInfo startLive(DjiPriProperties properties, SkDeviceCamera param) {
        if (ObjectUtil.isNotEmpty((Object)param.getProjectId())) {
            properties.setProjectUuid(param.getProjectId());
        }
        return (SkLiveInfo)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.startLive, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (boolean)true, (boolean)true));
    }

    public SkConverterState createConverter(DjiPriProperties properties, SkPriConverter param) {
        return (SkConverterState)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.createConverter, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (boolean)true, (boolean)true));
    }

    public boolean switchConverter(DjiPriProperties properties, SkSwitchConverter param) {
        if (ObjectUtil.isNotEmpty((Object)param.getProjectId())) {
            properties.setProjectUuid(param.getProjectId());
        }
        this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.switchConverter, MapUtil.of((Object)"converter_id", (Object)param.getConvertId()), BeanUtil.beanToMap((Object)param, (boolean)true, (boolean)true));
        return true;
    }

    public SkPageData<SkPriConverter> getConverter(DjiPriProperties properties) {
        SkPageData pageData = (SkPageData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getConverter, MapUtil.empty(), MapUtil.empty());
        SkPriLiveService skPriLiveService = this;
        return pageData.setList((List)skPriLiveService.priBaseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkPriConverter>>(){}));
    }

    public boolean deleteConverter(DjiPriProperties properties, String convertId) {
        this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.deleteConverter, MapUtil.of((Object)"converter_id", (Object)convertId), MapUtil.empty());
        return true;
    }
}

