/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.fczx.djipri.data.SkOrgDevice;
import com.geoway.fczx.djipri.data.SkPriTaskDetail;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.enmus.DjiPriRestApi;
import com.geoway.fczx.djipri.handler.AbstractDjiPriToFczxHandler;
import com.geoway.fczx.djipri.handler.DjiPriBaseHandler;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkMediaFile;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkProject;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.handler.AbstractDjskWhCallHandler;
import com.geoway.ue.common.data.page.PageDto;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkPriProjectService {
    private static final Logger log = LoggerFactory.getLogger(SkPriProjectService.class);
    @Resource
    private DjiPriBaseHandler priBaseHandler;
    @Autowired(required=false)
    private AbstractDjiPriToFczxHandler priConvertHandler;
    @Autowired(required=false)
    private AbstractDjskWhCallHandler whCallHandler;

    public SkPageData<SkProject> getPageOrgProjects(DjiPriProperties properties, PageDto param) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", param.getPageNum());
        map.put("page_size", param.getPageSize());
        SkPageData pageData = (SkPageData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getOrgProjects, map, MapUtil.empty());
        SkPriProjectService skPriProjectService = this;
        return pageData.setList((List)skPriProjectService.priBaseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkProject>>(){}));
    }

    public SkPageData<SkOrgDevice> getOrganDevices(DjiPriProperties properties) {
        SkPageData pageData = (SkPageData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getOrgDevices, MapUtil.empty(), MapUtil.empty());
        SkPriProjectService skPriProjectService = this;
        return pageData.setList((List)skPriProjectService.priBaseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkOrgDevice>>(){}));
    }

    public SkPageData<SkOrgDevice> getProjectDevices(DjiPriProperties properties, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        SkPageData pageData = (SkPageData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getProjectDevices, MapUtil.empty(), MapUtil.empty());
        SkPriProjectService skPriProjectService = this;
        return pageData.setList((List)skPriProjectService.priBaseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkOrgDevice>>(){}));
    }

    public SkToken obtainProjectToken(DjiPriProperties properties, String projectId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        return (SkToken)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.obtainProjectToken, MapUtil.empty(), MapUtil.empty());
    }

    public SkMediaFile getFile(DjiPriProperties properties, String fileId) {
        HashMap map = MapUtil.of((Object)"file_uuid", (Object)fileId);
        return (SkMediaFile)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getFile, map, MapUtil.empty());
    }

    public boolean syncOrganDevices(DjiPriProperties properties) {
        List<SkOrgDevice> list = this.obtainOrganDevices(properties);
        if (this.priConvertHandler != null && ObjectUtil.isNotEmpty(list)) {
            OpRes<Boolean> res = this.priConvertHandler.syncDjiPriDevices(list);
            if (this.whCallHandler != null) {
                ArrayList<SkDevice> datalist = new ArrayList<SkDevice>();
                list.forEach(d -> {
                    if (ObjectUtil.isNotEmpty((Object)d.getDrone())) {
                        datalist.add(d.getDrone());
                    }
                    if (ObjectUtil.isNotEmpty((Object)d.getGateway())) {
                        datalist.add(d.getGateway());
                    }
                });
                this.whCallHandler.syncDevicesAfter(datalist);
            }
            return res.isOpRes();
        }
        return false;
    }

    public List<SkOrgDevice> obtainOrganDevices(DjiPriProperties properties) {
        ArrayList<SkOrgDevice> list = new ArrayList<SkOrgDevice>();
        SkPageData<SkProject> projects = this.getPageOrgProjects(properties, new PageDto());
        if (projects != null && ObjectUtil.isNotEmpty(projects.getList())) {
            projects.getList().forEach(p -> {
                SkPageData<SkOrgDevice> devices = this.getProjectDevices(properties, p.getUuid());
                if (devices != null && ObjectUtil.isNotEmpty(devices.getList())) {
                    devices.getList().forEach(d -> d.setProject((SkProject)p));
                    list.addAll(devices.getList());
                }
            });
        }
        return list;
    }

    public boolean deliverTaskAfter(List<String> idList, List<SkPriTaskDetail> list, JSONObject metadata) {
        if (this.priConvertHandler != null && ObjectUtil.isNotEmpty(list)) {
            OpRes<Boolean> res = this.priConvertHandler.saveWaylineJobs(idList, list, metadata);
            return res.isOpRes();
        }
        return false;
    }
}

