/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djipri.services;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.geoway.fczx.djipri.data.SkPriTaskDetail;
import com.geoway.fczx.djipri.data.SkPriTaskParam;
import com.geoway.fczx.djipri.data.property.DjiPriProperties;
import com.geoway.fczx.djipri.enmus.DjiPriRestApi;
import com.geoway.fczx.djipri.handler.DjiPriBaseHandler;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTrack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SkPriTaskService {
    private static final Logger log = LoggerFactory.getLogger(SkPriTaskService.class);
    @Resource
    private DjiPriBaseHandler priBaseHandler;

    public SkResultData createFlightTask(DjiPriProperties properties, SkPriTaskParam param) {
        if (ObjectUtil.isNotEmpty((Object)param.getProjectUuid())) {
            properties.setProjectUuid(param.getProjectUuid());
        }
        return (SkResultData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.createFlightTask, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (boolean)true, (boolean)true));
    }

    public boolean updateTaskStatus(DjiPriProperties properties, String projectId, String taskId, String status) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.updateTaskStatus, MapUtil.of((Object)"task_uuid", (Object)taskId), MapUtil.of((Object)"status", (Object)status));
        return true;
    }

    public SkPriTaskDetail obtainTaskDetail(DjiPriProperties properties, String projectId, String taskId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        return (SkPriTaskDetail)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.obtainTaskDetail, MapUtil.of((Object)"task_uuid", (Object)taskId), MapUtil.empty());
    }

    public SkPageData<SkPriTaskDetail> obtainTaskList(DjiPriProperties properties, String projectId, Map<String, Object> param) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        SkPageData pageData = (SkPageData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.obtainTaskList, param, MapUtil.empty());
        SkPriTaskService skPriTaskService = this;
        return pageData.setList((List)skPriTaskService.priBaseHandler.getObjectMapper().convertValue(pageData.getList(), (TypeReference)new TypeReference<List<SkPriTaskDetail>>(){}));
    }

    public SkResultData obtainTaskFiles(DjiPriProperties properties, String projectId, String taskId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        return (SkResultData)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.obtainTaskFiles, MapUtil.of((Object)"task_uuid", (Object)taskId), MapUtil.empty());
    }

    public String obtainObsFile(DjiPriProperties properties, String projectId, String objectKey) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("object_key", objectKey);
        param.put("project_uuid", properties.getProjectUuid());
        return (String)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.getFileByObjectKey, param, MapUtil.empty());
    }

    public SkTrack obtainTaskTrack(DjiPriProperties properties, String projectId, String taskId) {
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            properties.setProjectUuid(projectId);
        }
        return (SkTrack)this.priBaseHandler.forwardDjiRequest(properties, DjiPriRestApi.obtainTaskTrack, MapUtil.of((Object)"task_uuid", (Object)taskId), MapUtil.empty());
    }
}

