/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.config;

import com.geoway.fczx.djsk.DjiFlighthubApp;
import io.swagger.v3.oas.annotations.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
public class DjskSwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(DjskSwaggerConfig.class);
    private static final String VERSION = "1.0";
    private static final String TITLE = "fczx-dji-fh";
    private static final String GROUP = "fczx-dji-fh";
    private static final String NAME = "liaoyongxiang";
    public static final String PKG = "com.geoway.fczx.djsk";
    private static final String URL = "http://geoway.com.cn/";
    private static final String DESCRIPTION = "\u5927\u7586\u53f8\u7a7a\u4e91\u7aef\u4e92\u8054\uff0c\u5c06\u5927\u7586\u53f8\u7a7a2\u8bbe\u5907\u540c\u6b65\u81f3\u8702\u5de2\u5e76\u53ef\u540c\u6b65\u6570\u636e\u6210\u679c\u53ca\u521b\u5efa\u98de\u884c\u4efb\u52a1";
    private static final String EMAIL = "liaoyongxiang@geoway.com.cn";

    @Bean(value={"fczx-dji-fh"})
    @ConditionalOnProperty(prefix="com.geoway.fczx.djsk", name={"show-doc"})
    public Docket api() {
        return this.showApi(false);
    }

    @Bean(value={"fczx-dji-fh"})
    @ConditionalOnBean(value={DjiFlighthubApp.class})
    public Docket allApi() {
        return this.showApi(true);
    }

    private Docket showApi(boolean flag) {
        Docket docket = new Docket(DocumentationType.OAS_30);
        docket.groupName("fczx-dji-fh");
        docket.apiInfo(this.apiInfo()).enable(true);
        docket.globalRequestParameters(this.setAuthHeader());
        ApiSelectorBuilder builder = new ApiSelectorBuilder(docket);
        Predicate handler = RequestHandlerSelectors.basePackage((String)PKG);
        handler = handler.and(RequestHandlerSelectors.withMethodAnnotation(Operation.class));
        if (flag) {
            handler = handler.and(RequestHandlerSelectors.withClassAnnotation(ConditionalOnBean.class));
        }
        builder.apis(handler);
        return builder.paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("fczx-dji-fh").description(DESCRIPTION).contact(new Contact(NAME, URL, EMAIL)).version(VERSION).build();
    }

    private List<RequestParameter> setAuthHeader() {
        ArrayList<RequestParameter> parameters = new ArrayList<RequestParameter>();
        parameters.add(new RequestParameterBuilder().name("X-Organization-Key").description("\u7ec4\u7ec7\u5bc6\u94a5").in(ParameterType.HEADER).query(q -> q.model(m -> m.scalarModel(ScalarType.STRING))).required(Boolean.valueOf(true)).build());
        return parameters;
    }
}

