/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.geoway.fczx.djsk.controller.SkBaseController;
import com.geoway.fczx.djsk.data.SkTask;
import com.geoway.fczx.djsk.enums.DjskNoticeType;
import com.geoway.fczx.djsk.restful.DjiFhRestService;
import com.geoway.fczx.djsk.services.SkProjectService;
import com.geoway.fczx.djsk.services.SkStreamService;
import com.geoway.fczx.djsk.services.SkWebhookService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u53f8\u7a7a\u63a5\u5165\u670d\u52a1"})
@RestController
@RequestMapping(value={"/api/djsk/flighthub/v1"})
public class SkFlightController
extends SkBaseController {
    private static final Logger log = LoggerFactory.getLogger(SkFlightController.class);
    @Resource
    private SkProjectService projectService;
    @Resource
    private SkWebhookService webhookService;
    @Resource
    private DjiFhRestService djiFhRestService;
    @Resource
    private SkStreamService streamService;

    @Operation(summary="hook\u63a5\u53e3\u56de\u8c03")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/call"})
    public ResponseEntity<BaseResponse> allMethodCall(@RequestBody(required=false) Map<String, Object> param) {
        DjskNoticeType type;
        log.debug("\u63a5\u6536\u5927\u7586\u53f8\u7a7a\u6570\u636ebody{}", (Object)JSONUtil.toJsonStr(param));
        if (param != null && param.containsKey("notify_type") && ObjectUtil.notEqual((Object)((Object)(type = DjskNoticeType.find((String)param.get("notify_type")))), (Object)((Object)DjskNoticeType.unknown))) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                Object data = objectMapper.readValue(JSONUtil.toJsonStr(param), type.getArgClass());
                ReflectUtil.invoke((Object)this.webhookService, (String)type.getMethod(), (Object[])new Object[]{data});
                return BaseResponse.ok();
            }
            catch (Exception e) {
                log.error("\u63a5\u6536\u6570\u636e{}\u8f6c\u6362\u5f02\u5e38", (Object)JSONUtil.toJsonStr(param), (Object)e);
                return BaseResponse.error((String)"\u63a5\u6536\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            }
        }
        return BaseResponse.error((String)"\u672a\u77e5\u6d88\u606f\u901a\u77e5");
    }

    @Operation(summary="\u540c\u6b65\u53f8\u7a7a\u8bbe\u5907", description="\u5c06\u5927\u7586\u53f8\u7a7a2\u6307\u5b9a\u7ec4\u7ec7\u8bbe\u5907\u5168\u90e8\u83b7\u53d6\u5e76\u540c\u6b65\u81f3\u8702\u5de2")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/sync/devices"})
    public ResponseEntity<BaseResponse> syncOrganDevices() {
        boolean flag = this.projectService.syncOrganDevices(this.obtainOrgKey());
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u8bbe\u5907\u5217\u8868\u5931\u8d25");
    }

    @Operation(summary="\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6", description="\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u81f3\u5927\u7586\u53f8\u7a7a2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="\u5927\u7586\u53f8\u7a7a\u9879\u76eeuuid", required=true), @ApiImplicitParam(name="withNotice", value="\u662f\u5426\u540c\u6b65\u53d1\u9001\u6d88\u606f\u901a\u77e5", required=true)})
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/upload/wayline"})
    public ResponseEntity<BaseResponse> uploadWayline(@RequestPart MultipartFile file, @RequestParam String projectId, Boolean withNotice) {
        if (ObjectUtil.notEqual((Object)"kmz", (Object)FileUtil.getSuffix((String)file.getOriginalFilename()))) {
            return BaseResponse.error((String)"\u4e0d\u652f\u6301\u8be5\u683c\u5f0f\u7c7b\u578b\u7684\u822a\u7ebf\u6587\u4ef6");
        }
        OpRes<String> opRes = this.djiFhRestService.uploadWayline(this.obtainOrgKey(), projectId, file, withNotice);
        return opRes.isOpRes() ? ObjectResponse.ok((Object)opRes.getData()) : BaseResponse.error((String)opRes.getErrorDesc());
    }

    @Operation(summary="\u4e0b\u53d1\u822a\u7ebf\u4efb\u52a1", description="\u4e0b\u53d1\u5927\u7586\u53f8\u7a7a2\u822a\u7ebf\u4efb\u52a1<h2>\u53ea\u652f\u6301\u7acb\u5373\u6267\u884c</h2>")
    @ApiImplicitParam(name="withCheck", value="\u662f\u5426\u68c0\u67e5\u8bbe\u5907\u4e0e\u9879\u76ee\u4e00\u81f4", required=true)
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/deliver/task"})
    public ResponseEntity<BaseResponse> deliverTask(@RequestBody SkTask param, Boolean withCheck) {
        if (param == null || ObjectUtil.isEmpty((Object)param.getProject_uuid()) || ObjectUtil.isEmpty((Object)param.getSn()) || ObjectUtil.isEmpty((Object)param.getWayline_uuid())) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        OpRes<List<String>> data = this.djiFhRestService.makeFlightNow(this.obtainOrgKey(), param.getProject_uuid(), param, withCheck, false);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u76f4\u64ad\u80fd\u529b", description="\u83b7\u53d6\u63a5\u5165\u5927\u7586\u53f8\u7a7a2\u8bbe\u5907\u7684\u76f4\u64ad\u80fd\u529b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="projectId", value="\u5927\u7586\u53f8\u7a7a\u9879\u76eeuuid"), @ApiImplicitParam(name="deviceSn", value="\u8bbe\u5907SN\u7801")})
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/video/capacity"})
    public ResponseEntity<BaseResponse> getVideoCapacity(@RequestParam(required=false) String deviceSn, @RequestParam(required=false) String projectId) {
        OpRes<Collection<Map<String, Object>>> opRes = this.djiFhRestService.getVideoCapacity(this.obtainOrgKey(), projectId, deviceSn);
        return opRes.isOpRes() ? ObjectResponse.ok((Object)opRes.getData()) : BaseResponse.error((String)opRes.getErrorDesc());
    }

    @Operation(summary="\u5173\u95ed\u8bbe\u5907\u63a8\u6d41", description="\u5927\u7586\u53f8\u7a7a\u516c\u6709\u7248\u5173\u95ed\u65c1\u8def\u63a8\u6d41")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deviceSn", value="\u8bbe\u5907SN\u7801", required=true), @ApiImplicitParam(name="payload", value="\u76f8\u673a\u8d1f\u8f7d", required=true)})
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/close/convert"})
    public ResponseEntity<BaseResponse> closeDeviceConvert(@RequestParam String deviceSn, @RequestParam String payload) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{deviceSn, payload})) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.streamService.closeDeviceConvert(this.obtainOrgKey(), deviceSn, payload);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5173\u95ed\u8bbe\u5907\u65c1\u8def\u63a8\u6d41\u5931\u8d25");
    }
}

