/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.controller;

import com.geoway.fczx.djsk.DjiFlighthubApp;
import com.geoway.fczx.djsk.controller.SkBaseController;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTask;
import com.geoway.fczx.djsk.data.SkTaskCmd;
import com.geoway.fczx.djsk.data.SkTaskDetail;
import com.geoway.fczx.djsk.data.SkTrack;
import com.geoway.fczx.djsk.services.SkTaskService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53f8\u7a7a\u4efb\u52a1\u63a5\u53e3"})
@RestController
@ConditionalOnBean(value={DjiFlighthubApp.class})
@RequestMapping(value={"/api/djsk/task/v1"})
public class SkTaskController
extends SkBaseController {
    @Resource
    private SkTaskService taskService;

    @Operation(summary="\u521b\u5efa\u98de\u884c\u4efb\u52a1")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/create/flight"})
    public ResponseEntity<BaseResponse> createFlightTask(@RequestParam String projectId, @RequestBody SkTask param) {
        SkResultData data = this.taskService.createFlightTask(this.obtainOrgKey(), projectId, param);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u4efb\u52a1\u6307\u4ee4\u4e0b\u53d1")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/execute/cmd"})
    public ResponseEntity<BaseResponse> executeCommand(@RequestParam String projectId, @RequestBody SkTaskCmd param) {
        Boolean data = this.taskService.executeCommand(this.obtainOrgKey(), projectId, param);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u8f68\u8ff9")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/{taskId}/track"})
    public ResponseEntity<BaseResponse> obtainTaskTrack(@RequestParam String projectId, @PathVariable String taskId) {
        SkTrack data = this.taskService.obtainTaskTrack(this.obtainOrgKey(), projectId, taskId);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/{taskId}/detail"})
    public ResponseEntity<BaseResponse> obtainTaskDetail(@RequestParam String projectId, @PathVariable String taskId) {
        SkTaskDetail data = this.taskService.obtainTaskDetail(this.obtainOrgKey(), projectId, taskId);
        return ObjectResponse.ok((Object)data);
    }
}

