/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.data.call;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.djsk.data.SkTaskDetail;
import com.geoway.fczx.djsk.data.call.SkBaseCallback;
import com.geoway.fczx.djsk.data.message.DjiBaseMessage;
import com.geoway.fczx.djsk.enums.DjskNoticeType;
import java.util.HashMap;
import java.util.Map;

public class SkTaskProgressCall
extends SkBaseCallback {
    private Long completeAt;
    private Integer currentWaypointIndex;
    private String landingDockSn;
    private String name;
    private Long progressVersion;
    private String resumableStatus;
    private Long runAt;
    private String sn;
    private Integer status;
    private Integer taskType;
    private Integer totalWaypoints;
    private String uuid;
    private String waylineUuid;
    private Integer waylineId;

    public String obtainStatus() {
        String state = "in_progress";
        switch (this.status) {
            case 2: {
                state = "in_progress";
                break;
            }
            case 3: {
                state = "paused";
                break;
            }
            case 5: {
                state = "ok";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                state = "failed";
                break;
            }
            case 8: {
                state = "partially_done";
            }
        }
        return state;
    }

    public DjiBaseMessage<Map<String, Object>> convertTaskProgressCallback() {
        HashMap<String, Object> ext = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Object> output = new HashMap<String, Object>();
        HashMap<String, Integer> progress = new HashMap<String, Integer>();
        DjiBaseMessage<Map<String, Object>> message = new DjiBaseMessage<Map<String, Object>>();
        message.setBid(this.uuid);
        message.setData(data);
        message.setGateway(this.sn);
        message.setTid(IdUtil.randomUUID());
        message.setTimestamp(System.currentTimeMillis());
        message.setMethod(DjskNoticeType.taskProgress.getType());
        data.put("result", 0);
        data.put("source", "dji");
        data.put("output", output);
        output.put("ext", ext);
        output.put("progress", progress);
        output.put("status", this.obtainStatus());
        ext.put("track_id", "");
        ext.put("flight_id", this.uuid);
        ext.put("media_count", 0);
        ext.put("wayline_uuid", this.waylineUuid);
        ext.put("wayline_mission_state", this.status);
        ext.put("current_waypoint_index", this.currentWaypointIndex != null ? this.currentWaypointIndex : 0);
        progress.put("current_step", 0);
        progress.put("percent", this.totalWaypoints != null && ObjectUtil.notEqual((Object)this.totalWaypoints, (Object)0) ? this.currentWaypointIndex / this.totalWaypoints : 0);
        return message;
    }

    public static SkTaskProgressCall buildTaskProgressCall(SkTaskDetail detail) {
        int status = 1;
        SkTaskProgressCall progress = new SkTaskProgressCall();
        if (detail != null) {
            if (ObjectUtil.isNotEmpty((Object)detail.getStatus())) {
                status = detail.getStatus();
            }
            if (ObjectUtil.isNotEmpty((Object)detail.getBeginAt())) {
                progress.setRunAt(detail.getBeginAt().getTime() / 1000L);
            }
            if (ObjectUtil.isNotEmpty((Object)detail.getEndAt())) {
                progress.setCompleteAt(detail.getEndAt().getTime() / 1000L);
            }
        }
        progress.setStatus(status);
        progress.setTotalWaypoints(0);
        progress.setCurrentWaypointIndex(0);
        return progress;
    }

    public Long getCompleteAt() {
        return this.completeAt;
    }

    public Integer getCurrentWaypointIndex() {
        return this.currentWaypointIndex;
    }

    public String getLandingDockSn() {
        return this.landingDockSn;
    }

    public String getName() {
        return this.name;
    }

    public Long getProgressVersion() {
        return this.progressVersion;
    }

    public String getResumableStatus() {
        return this.resumableStatus;
    }

    public Long getRunAt() {
        return this.runAt;
    }

    public String getSn() {
        return this.sn;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public Integer getTotalWaypoints() {
        return this.totalWaypoints;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getWaylineUuid() {
        return this.waylineUuid;
    }

    public Integer getWaylineId() {
        return this.waylineId;
    }

    public void setCompleteAt(Long completeAt) {
        this.completeAt = completeAt;
    }

    public void setCurrentWaypointIndex(Integer currentWaypointIndex) {
        this.currentWaypointIndex = currentWaypointIndex;
    }

    public void setLandingDockSn(String landingDockSn) {
        this.landingDockSn = landingDockSn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProgressVersion(Long progressVersion) {
        this.progressVersion = progressVersion;
    }

    public void setResumableStatus(String resumableStatus) {
        this.resumableStatus = resumableStatus;
    }

    public void setRunAt(Long runAt) {
        this.runAt = runAt;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public void setTotalWaypoints(Integer totalWaypoints) {
        this.totalWaypoints = totalWaypoints;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setWaylineUuid(String waylineUuid) {
        this.waylineUuid = waylineUuid;
    }

    public void setWaylineId(Integer waylineId) {
        this.waylineId = waylineId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkTaskProgressCall)) {
            return false;
        }
        SkTaskProgressCall other = (SkTaskProgressCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$completeAt = this.getCompleteAt();
        Long other$completeAt = other.getCompleteAt();
        if (this$completeAt == null ? other$completeAt != null : !((Object)this$completeAt).equals(other$completeAt)) {
            return false;
        }
        Integer this$currentWaypointIndex = this.getCurrentWaypointIndex();
        Integer other$currentWaypointIndex = other.getCurrentWaypointIndex();
        if (this$currentWaypointIndex == null ? other$currentWaypointIndex != null : !((Object)this$currentWaypointIndex).equals(other$currentWaypointIndex)) {
            return false;
        }
        Long this$progressVersion = this.getProgressVersion();
        Long other$progressVersion = other.getProgressVersion();
        if (this$progressVersion == null ? other$progressVersion != null : !((Object)this$progressVersion).equals(other$progressVersion)) {
            return false;
        }
        Long this$runAt = this.getRunAt();
        Long other$runAt = other.getRunAt();
        if (this$runAt == null ? other$runAt != null : !((Object)this$runAt).equals(other$runAt)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$taskType = this.getTaskType();
        Integer other$taskType = other.getTaskType();
        if (this$taskType == null ? other$taskType != null : !((Object)this$taskType).equals(other$taskType)) {
            return false;
        }
        Integer this$totalWaypoints = this.getTotalWaypoints();
        Integer other$totalWaypoints = other.getTotalWaypoints();
        if (this$totalWaypoints == null ? other$totalWaypoints != null : !((Object)this$totalWaypoints).equals(other$totalWaypoints)) {
            return false;
        }
        Integer this$waylineId = this.getWaylineId();
        Integer other$waylineId = other.getWaylineId();
        if (this$waylineId == null ? other$waylineId != null : !((Object)this$waylineId).equals(other$waylineId)) {
            return false;
        }
        String this$landingDockSn = this.getLandingDockSn();
        String other$landingDockSn = other.getLandingDockSn();
        if (this$landingDockSn == null ? other$landingDockSn != null : !this$landingDockSn.equals(other$landingDockSn)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$resumableStatus = this.getResumableStatus();
        String other$resumableStatus = other.getResumableStatus();
        if (this$resumableStatus == null ? other$resumableStatus != null : !this$resumableStatus.equals(other$resumableStatus)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$waylineUuid = this.getWaylineUuid();
        String other$waylineUuid = other.getWaylineUuid();
        return !(this$waylineUuid == null ? other$waylineUuid != null : !this$waylineUuid.equals(other$waylineUuid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SkTaskProgressCall;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $completeAt = this.getCompleteAt();
        result = result * 59 + ($completeAt == null ? 43 : ((Object)$completeAt).hashCode());
        Integer $currentWaypointIndex = this.getCurrentWaypointIndex();
        result = result * 59 + ($currentWaypointIndex == null ? 43 : ((Object)$currentWaypointIndex).hashCode());
        Long $progressVersion = this.getProgressVersion();
        result = result * 59 + ($progressVersion == null ? 43 : ((Object)$progressVersion).hashCode());
        Long $runAt = this.getRunAt();
        result = result * 59 + ($runAt == null ? 43 : ((Object)$runAt).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $taskType = this.getTaskType();
        result = result * 59 + ($taskType == null ? 43 : ((Object)$taskType).hashCode());
        Integer $totalWaypoints = this.getTotalWaypoints();
        result = result * 59 + ($totalWaypoints == null ? 43 : ((Object)$totalWaypoints).hashCode());
        Integer $waylineId = this.getWaylineId();
        result = result * 59 + ($waylineId == null ? 43 : ((Object)$waylineId).hashCode());
        String $landingDockSn = this.getLandingDockSn();
        result = result * 59 + ($landingDockSn == null ? 43 : $landingDockSn.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $resumableStatus = this.getResumableStatus();
        result = result * 59 + ($resumableStatus == null ? 43 : $resumableStatus.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $waylineUuid = this.getWaylineUuid();
        result = result * 59 + ($waylineUuid == null ? 43 : $waylineUuid.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SkTaskProgressCall(completeAt=" + this.getCompleteAt() + ", currentWaypointIndex=" + this.getCurrentWaypointIndex() + ", landingDockSn=" + this.getLandingDockSn() + ", name=" + this.getName() + ", progressVersion=" + this.getProgressVersion() + ", resumableStatus=" + this.getResumableStatus() + ", runAt=" + this.getRunAt() + ", sn=" + this.getSn() + ", status=" + this.getStatus() + ", taskType=" + this.getTaskType() + ", totalWaypoints=" + this.getTotalWaypoints() + ", uuid=" + this.getUuid() + ", waylineUuid=" + this.getWaylineUuid() + ", waylineId=" + this.getWaylineId() + ")";
    }
}

