/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.enums;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.djsk.data.call.SkBaseCallback;
import com.geoway.fczx.djsk.data.call.SkExitReturnCall;
import com.geoway.fczx.djsk.data.call.SkFileUploadCall;
import com.geoway.fczx.djsk.data.call.SkReturnHomeCall;
import com.geoway.fczx.djsk.data.call.SkTaskProgressCall;
import com.geoway.fczx.djsk.data.call.SkWaylineUploadCall;
import java.util.Arrays;

public enum DjskNoticeType {
    drcUpload("drc_file_upload_complete", "fileUploadCall", SkFileUploadCall.class),
    fileUpload("way_line_file_upload_complete", "fileUploadCall", SkFileUploadCall.class),
    waylineUpload("file_uploaded", "waylineUploadCall", SkWaylineUploadCall.class),
    taskProgress("flighttask_progress", "taskProgressCall", SkTaskProgressCall.class),
    returnHome("device_return_home", "returnHomeCall", SkReturnHomeCall.class),
    exitReturn("device_exit_return_home", "exitReturnCall", SkExitReturnCall.class),
    unknown("", "", SkBaseCallback.class);

    private final String type;
    private final String method;
    private final Class<? extends SkBaseCallback> argClass;

    public static DjskNoticeType find(String type) {
        return Arrays.stream(DjskNoticeType.values()).filter(item -> ObjectUtil.equal((Object)item.type, (Object)type)).findFirst().orElse(unknown);
    }

    public String getType() {
        return this.type;
    }

    public String getMethod() {
        return this.method;
    }

    public Class<? extends SkBaseCallback> getArgClass() {
        return this.argClass;
    }

    private DjskNoticeType(String type, String method, Class<? extends SkBaseCallback> argClass) {
        this.type = type;
        this.method = method;
        this.argClass = argClass;
    }
}

