/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.handler;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.geoway.fczx.djsk.data.SkBaseResult;
import com.geoway.fczx.djsk.data.property.DjskProperties;
import com.geoway.fczx.djsk.enums.DjskRestApi;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DjskBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(DjskBaseHandler.class);
    @Resource
    private RestTemplate djiFhApiRest;
    @Resource
    private DjskProperties djskProperties;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public <T> T forwardDjskRequest(String orgKey, DjskRestApi api, Map<String, Object> params, Map<String, Object> body) {
        String server = this.djskProperties.getApiUrl();
        if (ObjectUtil.isEmpty((Object)server)) {
            log.error("\u5927\u7586\u53f8\u7a7a\u4e91\u7aef\u4e92\u8054\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u5927\u7586\u53f8\u7a7a\u4e91\u7aef\u4e92\u8054\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("X-Organization-Key", orgKey);
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = server.concat(api.getUri());
        ResponseEntity res = this.djiFhApiRest.exchange(url, api.getMethod(), request, SkBaseResult.class, params);
        boolean flag = this.resolveResultBool((ResponseEntity<SkBaseResult>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u8f6c\u53d1\u5927\u7586\u53f8\u7a7a\u4e91\u7aef\u4e92\u8054\u63a5\u53e3\u8bf7\u6c42{}\u5931\u8d25\uff1a{}", (Object)api.getUri(), res.getBody());
            throw new RuntimeException("\u8f6c\u53d1\u5927\u7586\u53f8\u7a7a\u4e91\u7aef\u4e92\u8054\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        try {
            if (ObjectUtil.isNotEmpty(((SkBaseResult)res.getBody()).getData())) {
                return (T)objectMapper.readValue(JSONUtil.toJsonStr(((SkBaseResult)res.getBody()).getData()), api.getClazz());
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5927\u7586\u53f8\u7a7a\u8bf7\u6c42{}\u89e3\u6790\u7ed3\u679c\u5931\u8d25\uff1a{}", new Object[]{api.getUri(), res.getBody(), e});
            throw new RuntimeException("\u83b7\u53d6\u5927\u7586\u53f8\u7a7a\u8bf7\u6c42\u89e3\u6790\u7ed3\u679c\u5931\u8d25");
        }
    }

    private boolean resolveResultBool(ResponseEntity<SkBaseResult> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return Objects.requireNonNull((SkBaseResult)res.getBody()).getCode() == 0;
        }
        return false;
    }

    static {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

