/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.djsk.restful;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.PutObjectResult;
import com.geoway.fczx.djsk.data.SkDevice;
import com.geoway.fczx.djsk.data.SkDeviceTopo;
import com.geoway.fczx.djsk.data.SkMediaFile;
import com.geoway.fczx.djsk.data.SkPageData;
import com.geoway.fczx.djsk.data.SkProject;
import com.geoway.fczx.djsk.data.SkResultData;
import com.geoway.fczx.djsk.data.SkTask;
import com.geoway.fczx.djsk.data.SkTaskCmd;
import com.geoway.fczx.djsk.data.SkTaskDetail;
import com.geoway.fczx.djsk.data.SkToken;
import com.geoway.fczx.djsk.data.SkWayline;
import com.geoway.fczx.djsk.data.SkWaylineFile;
import com.geoway.fczx.djsk.data.call.SkTaskProgressCall;
import com.geoway.fczx.djsk.enums.DjskNoticeType;
import com.geoway.fczx.djsk.services.SkProjectService;
import com.geoway.fczx.djsk.services.SkTaskService;
import com.geoway.fczx.djsk.services.SkWebhookService;
import com.geoway.ue.common.data.response.OpRes;
import com.geoway.ue.common.util.Path;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DjiFhRestService {
    private static final Logger log = LoggerFactory.getLogger(DjiFhRestService.class);
    @Resource
    private SkProjectService projectService;
    @Resource
    private SkWebhookService webhookService;
    @Resource
    private SkTaskService taskService;

    public String droneReturnHome(String orgKey, String projectId, String deviceSn) {
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.taskService.executeCommand(orgKey, projectId, new SkTaskCmd("return_home", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u8fd4\u822a\u5931\u8d25";
    }

    public String droneCancelHome(String orgKey, String projectId, String deviceSn) {
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.taskService.executeCommand(orgKey, projectId, new SkTaskCmd("return_home_cancel", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u53d6\u6d88\u8fd4\u822a\u5931\u8d25";
    }

    public String flightPause(String orgKey, String projectId, String deviceSn, String jobId) {
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.taskService.executeCommand(orgKey, projectId, new SkTaskCmd("flighttask_pause", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u6682\u505c\u98de\u884c\u5931\u8d25";
    }

    public String flightRecovery(String orgKey, String projectId, String deviceSn, String jobId) {
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return "\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584";
        }
        boolean flag = this.taskService.executeCommand(orgKey, projectId, new SkTaskCmd("flighttask_recovery", deviceSn));
        return flag ? null : "\u65e0\u4eba\u673a\u6062\u590d\u98de\u884c\u5931\u8d25";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpRes<String> uploadWayline(String orgKey, String projectId, String file, Boolean withNotice) {
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        SkToken token = this.projectService.obtainProjectToken(orgKey, projectId);
        if (ObjectUtil.isEmpty((Object)token)) {
            return new OpRes("\u83b7\u53d6\u4e34\u65f6\u4e0a\u4f20\u51ed\u8bc1\u5931\u8d25", null, false);
        }
        OSS ossClient = null;
        try {
            block11: {
                String filename = FileUtil.getName((String)file);
                ossClient = new OSSClientBuilder().build(token.getEndpoint(), token.getCredentials().getAccessKeyId(), token.getCredentials().getAccessKeySecret(), token.getCredentials().getSecurityToken());
                String base = Path.joinPath((String)"/", (String[])new String[]{token.getObjectKeyPrefix(), IdUtil.randomUUID()});
                String objectKey = Path.joinPath((String)"/", (String[])new String[]{base, filename});
                PutObjectResult put = ossClient.putObject(token.getBucket(), objectKey, (InputStream)FileUtil.getInputStream((String)file));
                SkWaylineFile waylineFile = new SkWaylineFile(FileUtil.getPrefix((String)filename), objectKey);
                log.debug("{}", (Object)JSONUtil.toJsonPrettyStr((Object)waylineFile));
                if (!BooleanUtil.isTrue((Boolean)withNotice)) break;
                SkWayline skWayline = this.projectService.callProjectWayline(orgKey, projectId, waylineFile);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("size", 50);
                int page = 1;
                long total = 0L;
                params.put("page", page);
                SkPageData<SkWayline> waylines = this.projectService.getProjectWaylines(orgKey, projectId, params);
                if (waylines == null) break block11;
                if (waylines.getList() == null) break;
                total = waylines.getPagination().getTotal();
                for (SkWayline wayline : waylines.getList()) {
                    SkMediaFile mediaFile;
                    if (!wayline.getName().startsWith(FileUtil.getPrefix((String)filename)) || (mediaFile = this.projectService.getFile(orgKey, wayline.getId())) == null || !ObjectUtil.contains((Object)mediaFile.getUrl(), (Object)base)) continue;
                    OpRes opRes = new OpRes(null, (Object)wayline.getId(), true);
                    return opRes;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return new OpRes("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", null, false);
    }

    public OpRes<List<String>> makeFlightNow(String orgKey, String projectId, SkTask param, Boolean withCheck, boolean async) {
        Object res;
        log.debug("param={}", (Object)JSONUtil.toJsonStr((Object)param));
        if (!this.checkDjiOrganInfo(orgKey, projectId)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        if (ObjectUtil.notEqual((Object)param.getTask_type(), (Object)1)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4e0a\u8bbe\u5907\u53ea\u652f\u6301\u7acb\u5373\u6267\u884c\u4efb\u52a1", null, false);
        }
        boolean flag = true;
        if (BooleanUtil.isTrue((Boolean)withCheck)) {
            flag = false;
            res = this.projectService.getProjectDevices(orgKey, projectId);
            if (res != null && ObjectUtil.isNotEmpty(((SkPageData)res).getList())) {
                Optional<SkDevice> dev = ((SkPageData)res).getList().stream().filter(e -> ObjectUtil.equal((Object)e.getDeviceSn(), (Object)param.getSn())).findFirst();
                flag = dev.isPresent();
            }
        }
        if (flag) {
            res = this.taskService.createFlightTask(orgKey, projectId, param);
            if (res != null && ((SkResultData)res).getTask() != null && ObjectUtil.isNotEmpty((Object)((SkResultData)res).getTask().getUuid())) {
                if (async) {
                    ThreadUtil.execute(() -> this.lambda$makeFlightNow$1(orgKey, projectId, (SkResultData)res, param));
                }
                return new OpRes(null, Collections.singletonList(((SkResultData)res).getTask().getUuid()), true);
            }
        } else {
            log.error("\u9879\u76ee{}\u4e2d\u672a\u627e\u5230\u8be5\u8bbe\u5907{}", (Object)projectId, (Object)param.getSn());
            return new OpRes("\u9879\u76ee\u4e2d\u672a\u627e\u5230\u8be5\u8bbe\u5907", null, false);
        }
        log.error("\u521b\u5efa\u4efb\u52a1\u5931\u8d25{}", (Object)param);
        return new OpRes("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpRes<String> uploadWayline(String orgKey, String projectId, MultipartFile file, Boolean withNotice) {
        String output = file.getOriginalFilename();
        try {
            output = Path.joinPath((String)File.separator, (String[])new String[]{System.getProperty("user.dir"), "waylines", output});
            if (!FileUtil.exist((String)output)) {
                FileUtil.mkdir((String)new File(output).getParent());
                FileUtil.newFile((String)output);
            }
            FileUtil.writeBytes((byte[])file.getBytes(), (String)output);
            OpRes<String> opRes = this.uploadWayline(orgKey, projectId, output, withNotice);
            return opRes;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u822a\u7ebf\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            FileUtil.del((String)output);
        }
        return new OpRes("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", null, false);
    }

    private boolean checkDjiOrganInfo(String orgKey, String projectUuid) {
        if (ObjectUtil.isEmpty((Object)orgKey)) {
            log.error("\u5927\u7586\u53f8\u7a7a\u7ec4\u7ec7\u5bc6\u94a5\u672a\u83b7\u53d6");
            return false;
        }
        if (ObjectUtil.isEmpty((Object)projectUuid)) {
            log.error("\u5927\u7586\u53f8\u7a7a\u9879\u76eeuuid\u672a\u83b7\u53d6");
            return false;
        }
        return true;
    }

    public OpRes<Collection<Map<String, Object>>> getVideoCapacity(String orgKey, String projectId, String deviceSn) {
        if (ObjectUtil.isEmpty((Object)orgKey)) {
            return new OpRes("\u5927\u7586\u53f8\u7a7a\u4fe1\u606f\u4e0d\u5b8c\u5584", null, false);
        }
        List<Object> res = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)projectId)) {
            res = this.projectService.obtainDeviceTopo(orgKey, projectId);
        } else {
            List<SkProject> projects = this.projectService.getOrganProjects(orgKey);
            if (projects != null && !projects.isEmpty()) {
                for (SkProject skProject : projects) {
                    res.addAll(this.projectService.obtainDeviceTopo(orgKey, skProject.getUuid()));
                }
            }
        }
        if (res != null && ObjectUtil.isNotEmpty(res)) {
            HashSet list = new HashSet();
            for (SkDeviceTopo skDeviceTopo : res) {
                if (ObjectUtil.isNotEmpty((Object)skDeviceTopo.getHost())) {
                    HashMap<String, Object> map2 = new HashMap<String, Object>();
                    map2.put("sn", skDeviceTopo.getHost().getDeviceSn());
                    map2.put("name", skDeviceTopo.getHost().getNickname());
                    if (skDeviceTopo.getHost().getDeviceState() != null && ObjectUtil.isNotEmpty((Object)skDeviceTopo.getHost().getDeviceState().get((Object)"cameras"))) {
                        String[] payloads = (String[])skDeviceTopo.getHost().getDeviceState().getByPath("cameras.payload_index", String[].class);
                        ArrayList cameras = new ArrayList();
                        for (String payload : payloads) {
                            HashMap<String, Object> camera = new HashMap<String, Object>();
                            HashMap<String, Object> video = new HashMap<String, Object>();
                            camera.put("index", payload);
                            camera.put("videos_list", Collections.singletonList(video));
                            camera.put("name", skDeviceTopo.getHost().getDeviceModel().getName().concat(" Camera"));
                            video.put("type", "normal");
                            video.put("index", "normal-0");
                            video.put("switch_video_types", Collections.singletonList("normal"));
                            cameras.add(camera);
                        }
                        map2.put("cameras_list", cameras);
                    }
                    list.add(map2);
                }
                if (!ObjectUtil.isNotEmpty(skDeviceTopo.getParents())) continue;
                for (SkDevice device : skDeviceTopo.getParents()) {
                    HashMap<String, Object> map3 = new HashMap<String, Object>();
                    map3.put("sn", device.getDeviceSn());
                    map3.put("name", device.getNickname());
                    if (device.getDeviceState() != null && ObjectUtil.isNotEmpty((Object)device.getDeviceState().get((Object)"live_capacity"))) {
                        JSONArray devList = (JSONArray)device.getDeviceState().getByPath("live_capacity.device_list", JSONArray.class);
                        ArrayList cameras = new ArrayList();
                        for (JSONObject dev : devList.toList(JSONObject.class)) {
                            String[] payloads = (String[])dev.getByPath("camera_list.camera_index", String[].class);
                            JSONArray videoList = (JSONArray)dev.getByPath("camera_list.video_list", JSONArray.class);
                            for (String payload : payloads) {
                                String[][] videoType = (String[][])videoList.getByPath("video_type", String[][].class);
                                String[][] videoIndex = (String[][])videoList.getByPath("video_index", String[][].class);
                                String[][][] switchableVideoTypes = (String[][][])videoList.getByPath("switchable_video_types", String[][][].class);
                                HashMap<String, Object> camera = new HashMap<String, Object>();
                                HashMap<String, Object> video = new HashMap<String, Object>();
                                camera.put("name", device.getDeviceModel().getName().concat(" Camera"));
                                camera.put("videos_list", Collections.singletonList(video));
                                camera.put("index", payload);
                                video.put("type", videoType[0][0]);
                                video.put("index", videoIndex[0][0]);
                                video.put("switch_video_types", switchableVideoTypes[0][0]);
                                cameras.add(camera);
                            }
                        }
                        map3.put("cameras_list", cameras);
                    }
                    list.add(map3);
                }
            }
            if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{list, deviceSn})) {
                Optional<Map> capacity = list.stream().filter(e -> ObjectUtil.equal(e.get("sn"), (Object)deviceSn)).findFirst();
                return capacity.map(map -> new OpRes(null, Collections.singletonList(map), true)).orElseGet(() -> new OpRes(null, Collections.emptyList(), true));
            }
            return new OpRes(null, list, true);
        }
        return new OpRes("\u672a\u627e\u5230\u76f8\u5173\u8bbe\u5907\u8d1f\u8f7d\u4fe1\u606f", null, false);
    }

    private /* synthetic */ void lambda$makeFlightNow$1(String orgKey, String projectId, SkResultData res, SkTask param) {
        ThreadUtil.safeSleep((long)30000L);
        SkTaskDetail detail = this.taskService.obtainTaskDetail(orgKey, projectId, res.getTask().getUuid());
        SkTaskProgressCall progress = SkTaskProgressCall.buildTaskProgressCall(detail);
        progress.setSn(param.getSn());
        progress.setName(param.getName());
        progress.setProjectUuid(projectId);
        progress.setUuid(res.getTask().getUuid());
        progress.setTaskType(progress.getTaskType());
        progress.setWaylineUuid(param.getWayline_uuid());
        progress.setResumableStatus(param.getResumable_status());
        progress.setNotifyType(DjskNoticeType.taskProgress.getType());
        this.webhookService.taskProgressCall(progress);
    }
}

