/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.controller;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.jouav.data.JouavMissionNotice;
import com.geoway.fczx.jouav.data.JouavMissionSub;
import com.geoway.fczx.jouav.data.JouavToken;
import com.geoway.fczx.jouav.data.property.JouavProperties;
import com.geoway.fczx.jouav.service.JoFlightService;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.geoway.ue.common.data.response.OpRes;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Arrays;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7eb5\u6a2a\u63a5\u5165\u670d\u52a1"})
@RestController
@RequestMapping(value={"/api/jouav/flighthub/v1"})
public class JoFlightController {
    private static final Logger log = LoggerFactory.getLogger(JoFlightController.class);
    @Resource
    private JoFlightService flightService;

    @Operation(summary="\u63a5\u5165\u7eb5\u6a2a\u5e73\u53f0")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/access/platform"})
    public ResponseEntity<BaseResponse> accessPlatform(@RequestBody JouavProperties config, boolean forceAccess) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{config.getName(), config.getServerUrl(), config.getPassword(), config.getUsername()})) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.flightService.accessPlatform(config, forceAccess);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u63a5\u5165\u7eb5\u6a2a\u5e73\u53f0\u5931\u8d25");
    }

    @Operation(summary="\u79fb\u9664\u63a5\u5165\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/release/platform"})
    public ResponseEntity<BaseResponse> releasePlatform(@RequestParam String name) {
        if (ObjectUtil.isEmpty((Object)name)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.flightService.releasePlatform(name);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u79fb\u9664\u63a5\u5165\u4fe1\u606f\u5931\u8d25");
    }

    @Operation(summary="\u8ba2\u9605\u4efb\u52a1\u901a\u77e5")
    @ApiOperationSupport(order=3)
    @PostMapping(value={"/subscribe/mission"})
    public ResponseEntity<BaseResponse> subscribeMission(@RequestBody JouavMissionSub param) {
        if (!ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getCall(), param.getWorkspaceId()})) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.flightService.subscribeMission(param);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u8ba2\u9605\u4efb\u52a1\u901a\u77e5\u5931\u8d25");
    }

    @Operation(summary="\u53d6\u6d88\u4efb\u52a1\u901a\u77e5")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/unsubscribe/mission"})
    public ResponseEntity<BaseResponse> unsubscribeMission(@RequestParam String id) {
        if (ObjectUtil.isEmpty((Object)id)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.flightService.unsubscribeMission(id);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u79fb\u9664\u8ba2\u9605\u901a\u77e5\u5931\u8d25");
    }

    @Operation(summary="\u540c\u6b65\u7eb5\u6a2a\u8bbe\u5907", description="\u5c06\u7eb5\u6a2a\u65e0\u4eba\u673a\u7ba1\u63a7\u5e73\u53f0\u6307\u5b9a\u8d26\u53f7\u4e0b\u7684\u8bbe\u5907\u5168\u90e8\u83b7\u53d6\u5e76\u540c\u6b65\u81f3\u8702\u5de2")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/sync/devices"})
    public ResponseEntity<BaseResponse> syncAccountDevices() {
        boolean flag = this.flightService.syncAccountDevices();
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u8bbe\u5907\u5217\u8868\u5931\u8d25");
    }

    @Operation(summary="\u540c\u6b65\u7eb5\u6a2a\u8ba1\u5212", description="\u5c06\u7eb5\u6a2a\u65e0\u4eba\u673a\u7ba1\u63a7\u5e73\u53f0\u6307\u5b9a\u8d26\u53f7\u4e0b\u7684\u98de\u884c\u8ba1\u5212\u5168\u90e8\u83b7\u53d6\u5e76\u540c\u6b65\u81f3\u8702\u5de2")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/sync/plans"})
    public ResponseEntity<BaseResponse> syncAccountPlans() {
        boolean flag = this.flightService.syncAccountPlans();
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u540c\u6b65\u7eb5\u6a2a\u8ba1\u5212");
    }

    @Operation(summary="\u673a\u5e93\u98de\u673a\u7ed1\u5b9a", description="\u5c06\u7eb5\u6a2a\u65e0\u4eba\u673a\u673a\u5e93\u4e0e\u98de\u673a\u8fdb\u884c\u5173\u8054\u7ed1\u5b9a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="siteSn", value="\u673a\u573aSN", paramType="path", required=true), @ApiImplicitParam(name="pilotSn", value="\u98de\u673aSN", paramType="query", required=true)})
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/{siteSn}/bind"})
    public ResponseEntity<BaseResponse> bindSiteWithAir(@PathVariable String siteSn, @RequestParam String pilotSn) {
        boolean flag = this.flightService.bindSiteWithAir(siteSn, pilotSn);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u673a\u5e93\u98de\u673a\u7ed1\u5b9a\u5931\u8d25");
    }

    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u76f4\u64ad")
    @ApiImplicitParams(value={@ApiImplicitParam(name="sn", value="\u673a\u573aSN", paramType="query", required=true), @ApiImplicitParam(name="type", value="\u8bbe\u5907\u7c7b\u578b 0-\u98de\u673a 3-\u673a\u5e93", paramType="query", required=true)})
    @ApiOperationSupport(order=7)
    @PostMapping(value={"/device/live"})
    public ResponseEntity<BaseResponse> obtainDeviceLive(@RequestParam String sn, @RequestParam Integer type) {
        if (!ObjectUtil.contains(Arrays.asList(0, 3), (Object)type)) {
            return BaseResponse.error((String)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        Object data = this.flightService.obtainDeviceLive(sn, type);
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u8f6c\u6210\u8702\u5de2\u4efb\u52a1")
    @ApiOperationSupport(order=8)
    @PostMapping(value={"/flight/convert"})
    public ResponseEntity<BaseResponse> convertDroneFlight(@RequestParam String planNo, @RequestBody JSONObject param) {
        OpRes<Boolean> data = this.flightService.convertDroneFlight(planNo, param);
        return data.isOpRes() ? BaseResponse.ok() : BaseResponse.error((String)data.getErrorDesc());
    }

    @Operation(summary="\u5220\u9664\u9000\u51fa\u8ba1\u5212")
    @ApiOperationSupport(order=9)
    @PostMapping(value={"/exit/remove"})
    public ResponseEntity<BaseResponse> removeFailPlan(@RequestParam String planNo) {
        boolean flag = this.flightService.removeFailPlan(planNo);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u5220\u9664\u9000\u51fa\u8ba1\u5212\u5931\u8d25");
    }

    @Operation(summary="\u4efb\u52a1\u4fe1\u606f\u901a\u77e5")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/mission/notice"})
    public ResponseEntity<BaseResponse> noticeMission(@RequestBody JouavMissionNotice param) {
        log.info("{}", (Object)param.toString());
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{param.getAction(), param.getData(), param.getData().getPlanNo()})) {
            boolean flag = this.flightService.noticeMission(param);
            return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u8ba2\u9605\u4efb\u52a1\u901a\u77e5\u5931\u8d25");
        }
        return BaseResponse.ok();
    }

    @Operation(summary="\u4efb\u52a1\u81ea\u68c0\u8d77\u98de")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/mission/trigger"})
    public ResponseEntity<BaseResponse> triggerMission(String planNo, Boolean takeoff) {
        boolean flag = this.flightService.ExecuteDebug(planNo, takeoff);
        return flag ? BaseResponse.ok() : BaseResponse.error((String)"\u4efb\u52a1\u81ea\u68c0\u8d77\u98de\u5931\u8d25");
    }

    @Operation(summary="\u83b7\u53d6\u8ba4\u8bc1\u51ed\u8bc1")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/token"})
    public ResponseEntity<BaseResponse> obtainToken() {
        JouavToken data = this.flightService.obtainToken();
        return ObjectResponse.ok((Object)data);
    }

    @Operation(summary="\u662f\u5426\u63a5\u5165\u7eb5\u6a2a")
    @ApiOperationSupport(order=13)
    @GetMapping(value={"/check/access"})
    public ResponseEntity<BaseResponse> checkAccess() {
        JSONObject data = this.flightService.checkAccess();
        if (ObjectUtil.isNotEmpty((Object)data)) {
            return ObjectResponse.ok((Object)data.putOnce("access", (Object)true));
        }
        return ObjectResponse.ok((Object)MapUtil.of((Object)"access", (Object)false));
    }
}

