/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import com.geoway.fczx.jouav.data.param.JouavElevationDto;
import com.geoway.fczx.jouav.data.param.JouavMissionDto;
import com.geoway.fczx.jouav.data.param.JouavPlanVo;
import com.geoway.fczx.jouav.data.param.JouavRecordVo;
import com.geoway.fczx.jouav.data.param.JouavRouteDto;
import com.geoway.fczx.jouav.enmus.JouavRestApi;
import com.geoway.fczx.jouav.handler.JouavBaseHandler;
import com.geoway.ue.common.data.response.BaseResponse;
import com.geoway.ue.common.data.response.ObjectResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import java.util.HashMap;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7eb5\u6a2a\u822a\u7ebf\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/jouav/wayline/v1"})
public class JoWaylineController {
    @Resource
    private JouavBaseHandler jouavHandler;

    @Operation(summary="\u751f\u6210\u7eb5\u6a2a\u822a\u7ebf")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/generate/route"})
    public ResponseEntity<BaseResponse> generatingRoute(@RequestBody JouavRouteDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.generatingRoute, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u4fdd\u5b58\u4efb\u52a1\u8ba1\u5212", description="\u4fdd\u5b58/\u66f4\u65b0\u4efb\u52a1\u8ba1\u5212")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/replace/plan"})
    public ResponseEntity<BaseResponse> saveOrUpdatePlan(@RequestBody JouavMissionDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.saveOrUpdatePlan, MapUtil.empty(), BeanUtil.beanToMap((Object)param, (String[])new String[0]));
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u8ba1\u5212\u5217\u8868")
    @ApiOperationSupport(order=3, ignoreParameters={"queryEndAt", "queryStartAt", "sortByDesc", "planNo"})
    @GetMapping(value={"/plan/list"})
    public ResponseEntity<BaseResponse> planList(JouavPlanVo param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.planList, BeanUtil.beanToMap((Object)param, (String[])new String[0]), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u8ba1\u5212\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/plan/info"})
    public ResponseEntity<BaseResponse> planInfo(@RequestParam String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.planInfo, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u8ba1\u7b97\u5e73\u5747\u9ad8\u7a0b")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/mean/elevation"})
    public ResponseEntity<BaseResponse> getMeanElevation(@RequestBody JouavElevationDto param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.getMeanElevation, MapUtil.empty(), param);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u67b6\u6b21\u5217\u8868")
    @ApiOperationSupport(order=6, ignoreParameters={"categoryId", "planTargetIds", "uavType", "planName"})
    @GetMapping(value={"/record/list"})
    public ResponseEntity<BaseResponse> getRecordSimpleDataListByPlanNo(JouavPlanVo param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.getRecords, BeanUtil.beanToMap((Object)param, (String[])new String[0]), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u83b7\u53d6\u67b6\u6b21\u6587\u4ef6", description="\u83b7\u53d6\u5f55\u50cf")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/record/files"})
    public ResponseEntity<BaseResponse> getRecordFiles(JouavRecordVo param) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.getRecordFiles, BeanUtil.beanToMap((Object)param, (String[])new String[0]), null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u7b97\u5730\u9762\u5206\u8fa8\u7387")
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/calculate/gsd"})
    public ResponseEntity<BaseResponse> calculateGsd(@RequestParam Double relativeHeight, @RequestParam Double viewAngle) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("relativeHeight", relativeHeight);
        param.put("viewAngle", viewAngle);
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.calculateGsd, param, null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u7b97\u5730\u65c1\u5411\u95f4\u9694")
    @ApiOperationSupport(order=9)
    @GetMapping(value={"/calculate/space"})
    public ResponseEntity<BaseResponse> calculateWeftSpacing(Float overlapRatio, Double relativeHeight, Double viewAngle) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lateralOverlapRatio", overlapRatio);
        param.put("relativeHeight", relativeHeight);
        param.put("viewAngle", viewAngle);
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.calculateWeftSpacing, param, null);
        return ObjectResponse.ok(data);
    }

    @Operation(summary="\u5220\u9664\u8ba1\u5212\u4efb\u52a1")
    @ApiOperationSupport(order=10)
    @PostMapping(value={"/plan/{planNo}"})
    public ResponseEntity<BaseResponse> deletePlan(@PathVariable String planNo) {
        Object data = this.jouavHandler.forwardJouavRequest(JouavRestApi.deletePlan, MapUtil.of((Object)"planNo", (Object)planNo), null);
        return ObjectResponse.ok(data);
    }
}

