/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.data.message;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import com.geoway.fczx.jouav.data.message.JoPilotCamera;
import com.geoway.fczx.jouav.data.message.JoPilotControl;
import com.geoway.fczx.jouav.data.message.JoPilotGimbal;
import com.geoway.fczx.jouav.data.message.JoPilotGnss;
import com.geoway.fczx.jouav.data.message.JoPilotLidar;
import com.geoway.fczx.jouav.data.message.JoPilotNavigation;
import com.geoway.fczx.jouav.data.message.JoPilotSensor;
import com.geoway.fczx.jouav.data.message.JoPilotStandard;
import com.geoway.fczx.jouav.data.message.JoPilotSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JoPilotData {
    private JoPilotCamera camera;
    private JoPilotControl controlData;
    private JoPilotGimbal gimbalInfo;
    private JoPilotGnss gnssInfo;
    private JoPilotLidar lidarV2;
    private JoPilotNavigation navigationDetails;
    private JoPilotSensor sensor;
    private JoPilotStandard standardData;
    private JoPilotSystem systemInfo;

    public Map<String, Object> fmtDjiMqttData(String gateway) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        HashMap<String, Object> gimbal = new HashMap<String, Object>();
        HashMap battery = new HashMap();
        HashMap<String, Object> camera = new HashMap<String, Object>();
        HashMap<String, Integer> limit = new HashMap<String, Integer>();
        HashMap<String, Long> storage = new HashMap<String, Long>();
        HashMap<String, Number> position = new HashMap<String, Number>();
        if (this.gimbalInfo != null) {
            message.put("81-0-0", gimbal);
            gimbal.put("gimbal_pitch", this.gimbalInfo.getFramePitch());
            gimbal.put("gimbal_yaw", this.gimbalInfo.getFrameYaw());
            gimbal.put("payload_index", "81-0-0");
            gimbal.put("gimbal_roll", 0);
            gimbal.put("zoom_factor", 1);
        }
        message.put("home_distance", this.navigationDetails.getLbNextDist());
        message.put("activation_time", this.standardData.getTimeStamp());
        message.put("attitude_head", this.standardData.getUavYaw());
        message.put("attitude_pitch", this.standardData.getUavPitch());
        message.put("attitude_roll", this.standardData.getUavRoll());
        message.put("battery", battery);
        message.put("best_link_gateway", gateway);
        message.put("cameras", Collections.singletonList(camera));
        camera.put("payload_index", "81-0-0");
        camera.put("camera_mode", this.standardData.getCamStatus());
        camera.put("photo_state", 0);
        camera.put("photo_storage_settings", Collections.singletonList("vision"));
        camera.put("zoom_factor", 1);
        message.put("country", "CN");
        message.put("distance_limit_status", limit);
        limit.put("state", 0);
        limit.put("distance_limit", 5000);
        limit.put("is_near_distance_limit", 0);
        message.put("elevation", this.standardData.getUavAlt());
        message.put("rth_altitude", this.standardData.getUavAlt());
        message.put("height", this.standardData.getUavHMSL());
        message.put("height_limit", 500);
        message.put("is_near_area_limit", 0);
        message.put("is_near_height_limit", 0);
        message.put("latitude", this.standardData.getUavLat());
        message.put("longitude", this.standardData.getUavLon());
        message.put("maintain_status", MapUtil.empty());
        message.put("night_lights_state", 0);
        message.put("mode_code", this.standardData.getApMode());
        message.put("storage", storage);
        message.put("track_id", IdUtil.randomUUID());
        message.put("vertical_speed", this.standardData.getTAS());
        message.put("horizontal_speed", this.standardData.getVGnd());
        message.put("wind_speed", this.standardData.getWindSpeed());
        message.put("position_state", position);
        position.put("gps_number", this.standardData.getNumSV());
        position.put("is_fixed", this.standardData.getRtkExtSolStat());
        position.put("quality", this.standardData.getPDOP());
        position.put("rtk_number", 0);
        message.put("total_flight_distance", this.standardData.getFlightDistance());
        message.put("total_flight_sorties", 0);
        message.put("total_flight_time", 0);
        if (this.lidarV2 != null) {
            storage.put("total", this.lidarV2.getTotalSize());
            storage.put("used", this.lidarV2.getUsedSize());
        }
        return message;
    }

    public JoPilotCamera getCamera() {
        return this.camera;
    }

    public JoPilotControl getControlData() {
        return this.controlData;
    }

    public JoPilotGimbal getGimbalInfo() {
        return this.gimbalInfo;
    }

    public JoPilotGnss getGnssInfo() {
        return this.gnssInfo;
    }

    public JoPilotLidar getLidarV2() {
        return this.lidarV2;
    }

    public JoPilotNavigation getNavigationDetails() {
        return this.navigationDetails;
    }

    public JoPilotSensor getSensor() {
        return this.sensor;
    }

    public JoPilotStandard getStandardData() {
        return this.standardData;
    }

    public JoPilotSystem getSystemInfo() {
        return this.systemInfo;
    }

    public void setCamera(JoPilotCamera camera) {
        this.camera = camera;
    }

    public void setControlData(JoPilotControl controlData) {
        this.controlData = controlData;
    }

    public void setGimbalInfo(JoPilotGimbal gimbalInfo) {
        this.gimbalInfo = gimbalInfo;
    }

    public void setGnssInfo(JoPilotGnss gnssInfo) {
        this.gnssInfo = gnssInfo;
    }

    public void setLidarV2(JoPilotLidar lidarV2) {
        this.lidarV2 = lidarV2;
    }

    public void setNavigationDetails(JoPilotNavigation navigationDetails) {
        this.navigationDetails = navigationDetails;
    }

    public void setSensor(JoPilotSensor sensor) {
        this.sensor = sensor;
    }

    public void setStandardData(JoPilotStandard standardData) {
        this.standardData = standardData;
    }

    public void setSystemInfo(JoPilotSystem systemInfo) {
        this.systemInfo = systemInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoPilotData)) {
            return false;
        }
        JoPilotData other = (JoPilotData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JoPilotCamera this$camera = this.getCamera();
        JoPilotCamera other$camera = other.getCamera();
        if (this$camera == null ? other$camera != null : !((Object)this$camera).equals(other$camera)) {
            return false;
        }
        JoPilotControl this$controlData = this.getControlData();
        JoPilotControl other$controlData = other.getControlData();
        if (this$controlData == null ? other$controlData != null : !((Object)this$controlData).equals(other$controlData)) {
            return false;
        }
        JoPilotGimbal this$gimbalInfo = this.getGimbalInfo();
        JoPilotGimbal other$gimbalInfo = other.getGimbalInfo();
        if (this$gimbalInfo == null ? other$gimbalInfo != null : !((Object)this$gimbalInfo).equals(other$gimbalInfo)) {
            return false;
        }
        JoPilotGnss this$gnssInfo = this.getGnssInfo();
        JoPilotGnss other$gnssInfo = other.getGnssInfo();
        if (this$gnssInfo == null ? other$gnssInfo != null : !((Object)this$gnssInfo).equals(other$gnssInfo)) {
            return false;
        }
        JoPilotLidar this$lidarV2 = this.getLidarV2();
        JoPilotLidar other$lidarV2 = other.getLidarV2();
        if (this$lidarV2 == null ? other$lidarV2 != null : !((Object)this$lidarV2).equals(other$lidarV2)) {
            return false;
        }
        JoPilotNavigation this$navigationDetails = this.getNavigationDetails();
        JoPilotNavigation other$navigationDetails = other.getNavigationDetails();
        if (this$navigationDetails == null ? other$navigationDetails != null : !((Object)this$navigationDetails).equals(other$navigationDetails)) {
            return false;
        }
        JoPilotSensor this$sensor = this.getSensor();
        JoPilotSensor other$sensor = other.getSensor();
        if (this$sensor == null ? other$sensor != null : !((Object)this$sensor).equals(other$sensor)) {
            return false;
        }
        JoPilotStandard this$standardData = this.getStandardData();
        JoPilotStandard other$standardData = other.getStandardData();
        if (this$standardData == null ? other$standardData != null : !((Object)this$standardData).equals(other$standardData)) {
            return false;
        }
        JoPilotSystem this$systemInfo = this.getSystemInfo();
        JoPilotSystem other$systemInfo = other.getSystemInfo();
        return !(this$systemInfo == null ? other$systemInfo != null : !((Object)this$systemInfo).equals(other$systemInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoPilotData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JoPilotCamera $camera = this.getCamera();
        result = result * 59 + ($camera == null ? 43 : ((Object)$camera).hashCode());
        JoPilotControl $controlData = this.getControlData();
        result = result * 59 + ($controlData == null ? 43 : ((Object)$controlData).hashCode());
        JoPilotGimbal $gimbalInfo = this.getGimbalInfo();
        result = result * 59 + ($gimbalInfo == null ? 43 : ((Object)$gimbalInfo).hashCode());
        JoPilotGnss $gnssInfo = this.getGnssInfo();
        result = result * 59 + ($gnssInfo == null ? 43 : ((Object)$gnssInfo).hashCode());
        JoPilotLidar $lidarV2 = this.getLidarV2();
        result = result * 59 + ($lidarV2 == null ? 43 : ((Object)$lidarV2).hashCode());
        JoPilotNavigation $navigationDetails = this.getNavigationDetails();
        result = result * 59 + ($navigationDetails == null ? 43 : ((Object)$navigationDetails).hashCode());
        JoPilotSensor $sensor = this.getSensor();
        result = result * 59 + ($sensor == null ? 43 : ((Object)$sensor).hashCode());
        JoPilotStandard $standardData = this.getStandardData();
        result = result * 59 + ($standardData == null ? 43 : ((Object)$standardData).hashCode());
        JoPilotSystem $systemInfo = this.getSystemInfo();
        result = result * 59 + ($systemInfo == null ? 43 : ((Object)$systemInfo).hashCode());
        return result;
    }

    public String toString() {
        return "JoPilotData(camera=" + this.getCamera() + ", controlData=" + this.getControlData() + ", gimbalInfo=" + this.getGimbalInfo() + ", gnssInfo=" + this.getGnssInfo() + ", lidarV2=" + this.getLidarV2() + ", navigationDetails=" + this.getNavigationDetails() + ", sensor=" + this.getSensor() + ", standardData=" + this.getStandardData() + ", systemInfo=" + this.getSystemInfo() + ")";
    }
}

