/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.data.message;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.fczx.jouav.data.message.JoSiteBoard1;
import com.geoway.fczx.jouav.data.message.JoSiteBoard2;
import com.geoway.fczx.jouav.data.message.JoSiteNetRelay1;
import com.geoway.fczx.jouav.data.message.JoSiteNetRelay2;
import com.geoway.fczx.jouav.data.message.JoSitePowerBoad;
import com.geoway.fczx.jouav.data.message.JoSiteWeather;
import java.util.HashMap;
import java.util.Map;

public class JoSiteData {
    private JoSiteBoard1 board1;
    private JoSiteBoard2 board2;
    private JoSitePowerBoad powerBoad;
    private JoSiteNetRelay1 netRelay1;
    private JoSiteNetRelay2 netRelay2;
    private JoSiteWeather weatherStation;

    public Map<String, Object> fmtDjiMqttData(double lat, double lng, double height) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        HashMap<String, Integer> droneCharge = new HashMap<String, Integer>();
        HashMap<String, Number> storage = new HashMap<String, Number>();
        HashMap<String, Integer> airConditioner = new HashMap<String, Integer>();
        message.put("drone_charge_state", droneCharge);
        droneCharge.put("state", BooleanUtil.toInt((boolean)this.powerBoad.getChargeSwitch()));
        droneCharge.put("capacity_percent", this.powerBoad.getBatterSoc());
        message.put("drone_in_dock", BooleanUtil.toInt((boolean)ObjectUtil.equal((Object)"powerOff", (Object)this.board2.getUavState())));
        message.put("rainfall", this.weatherStation != null ? (double)this.buildRainFall(this.weatherStation.getRain()) : this.board2.getM2_Rainfall());
        message.put("wind_speed", this.weatherStation != null ? this.weatherStation.getWindSpeed() : this.board2.getM2_WindSpeed());
        message.put("environment_temperature", this.weatherStation != null ? this.weatherStation.getTemp() : this.board2.getM2_OutsideTemperature());
        message.put("temperature", this.board2.getM2_Temperature());
        message.put("humidity", this.weatherStation != null ? this.weatherStation.getHumi() : this.board2.getM2_Humidity());
        message.put("heading", this.board2.getM2_WindDirection());
        message.put("home_position_is_valid", this.board2.getM2_WeatherDataValid());
        message.put("latitude", lat);
        message.put("longitude", lng);
        message.put("height", height);
        message.put("storage", storage);
        storage.put("total", 100);
        storage.put("used", this.board2.getRamLoad());
        message.put("mode_code", this.convertModeCode(this.board1.getExecTaskStep()));
        message.put("silent_mode", 0);
        message.put("supplement_light_state", BooleanUtil.toInt((boolean)this.netRelay1.getLight()));
        message.put("cover_state", BooleanUtil.toInt((boolean)ObjectUtil.notEqual((Object)this.board2.getM2_StateMachine(), (Object)"Closing")));
        message.put("emergency_stop_state", BooleanUtil.toInt((boolean)ObjectUtil.equal((Object)this.board2.getM2_StateMachine(), (Object)"EmergencyStop")));
        message.put("air_conditioner", airConditioner);
        airConditioner.put("air_conditioner_state", BooleanUtil.toInt((boolean)BooleanUtil.isTrue((Boolean)this.board2.getAirConditionerSwitchState())));
        airConditioner.put("switch_time", 0);
        message.put("putter_state", 0);
        message.put("alarm_state", 0);
        return message;
    }

    private int buildRainFall(double rain) {
        if (rain > 10.0) {
            if (rain > 100.0) {
                return 3;
            }
            if (rain > 50.0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private int convertModeCode(String step) {
        switch (step) {
            case "none": {
                return 0;
            }
            case "chargerStop": {
                return 1;
            }
            case "resetM2": {
                return 2;
            }
            case "airSpeedCheck": {
                return 3;
            }
            case "takeOff": {
                return 4;
            }
            case "switchToVideo": {
                return 5;
            }
            case "waitingFix": {
                return 6;
            }
            case "waitingHeading": {
                return 7;
            }
            case "checkVideo": {
                return 8;
            }
            case "chechImpetus": {
                return 9;
            }
            case "loadCheck": {
                return 10;
            }
            case "waitingForTakeOff": {
                return 11;
            }
            case "TakeOffIng": {
                return 12;
            }
            case "waitingLevelFlight": {
                return 13;
            }
            case "closeDoor": {
                return 14;
            }
            case "executeTaskIng": {
                return 15;
            }
            case "openDoor": {
                return 16;
            }
            case "waitingForLanding": {
                return 17;
            }
            case "loadStatic": {
                return 18;
            }
            case "switchToAp": {
                return 19;
            }
            case "recycle": {
                return 20;
            }
            case "checkAp": {
                return 21;
            }
            case "success": {
                return 22;
            }
            case "fail": {
                return 23;
            }
            case "manualStop": {
                return 24;
            }
        }
        return 0;
    }

    public JoSiteBoard1 getBoard1() {
        return this.board1;
    }

    public JoSiteBoard2 getBoard2() {
        return this.board2;
    }

    public JoSitePowerBoad getPowerBoad() {
        return this.powerBoad;
    }

    public JoSiteNetRelay1 getNetRelay1() {
        return this.netRelay1;
    }

    public JoSiteNetRelay2 getNetRelay2() {
        return this.netRelay2;
    }

    public JoSiteWeather getWeatherStation() {
        return this.weatherStation;
    }

    public void setBoard1(JoSiteBoard1 board1) {
        this.board1 = board1;
    }

    public void setBoard2(JoSiteBoard2 board2) {
        this.board2 = board2;
    }

    public void setPowerBoad(JoSitePowerBoad powerBoad) {
        this.powerBoad = powerBoad;
    }

    public void setNetRelay1(JoSiteNetRelay1 netRelay1) {
        this.netRelay1 = netRelay1;
    }

    public void setNetRelay2(JoSiteNetRelay2 netRelay2) {
        this.netRelay2 = netRelay2;
    }

    public void setWeatherStation(JoSiteWeather weatherStation) {
        this.weatherStation = weatherStation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoSiteData)) {
            return false;
        }
        JoSiteData other = (JoSiteData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JoSiteBoard1 this$board1 = this.getBoard1();
        JoSiteBoard1 other$board1 = other.getBoard1();
        if (this$board1 == null ? other$board1 != null : !((Object)this$board1).equals(other$board1)) {
            return false;
        }
        JoSiteBoard2 this$board2 = this.getBoard2();
        JoSiteBoard2 other$board2 = other.getBoard2();
        if (this$board2 == null ? other$board2 != null : !((Object)this$board2).equals(other$board2)) {
            return false;
        }
        JoSitePowerBoad this$powerBoad = this.getPowerBoad();
        JoSitePowerBoad other$powerBoad = other.getPowerBoad();
        if (this$powerBoad == null ? other$powerBoad != null : !((Object)this$powerBoad).equals(other$powerBoad)) {
            return false;
        }
        JoSiteNetRelay1 this$netRelay1 = this.getNetRelay1();
        JoSiteNetRelay1 other$netRelay1 = other.getNetRelay1();
        if (this$netRelay1 == null ? other$netRelay1 != null : !((Object)this$netRelay1).equals(other$netRelay1)) {
            return false;
        }
        JoSiteNetRelay2 this$netRelay2 = this.getNetRelay2();
        JoSiteNetRelay2 other$netRelay2 = other.getNetRelay2();
        if (this$netRelay2 == null ? other$netRelay2 != null : !((Object)this$netRelay2).equals(other$netRelay2)) {
            return false;
        }
        JoSiteWeather this$weatherStation = this.getWeatherStation();
        JoSiteWeather other$weatherStation = other.getWeatherStation();
        return !(this$weatherStation == null ? other$weatherStation != null : !((Object)this$weatherStation).equals(other$weatherStation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoSiteData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JoSiteBoard1 $board1 = this.getBoard1();
        result = result * 59 + ($board1 == null ? 43 : ((Object)$board1).hashCode());
        JoSiteBoard2 $board2 = this.getBoard2();
        result = result * 59 + ($board2 == null ? 43 : ((Object)$board2).hashCode());
        JoSitePowerBoad $powerBoad = this.getPowerBoad();
        result = result * 59 + ($powerBoad == null ? 43 : ((Object)$powerBoad).hashCode());
        JoSiteNetRelay1 $netRelay1 = this.getNetRelay1();
        result = result * 59 + ($netRelay1 == null ? 43 : ((Object)$netRelay1).hashCode());
        JoSiteNetRelay2 $netRelay2 = this.getNetRelay2();
        result = result * 59 + ($netRelay2 == null ? 43 : ((Object)$netRelay2).hashCode());
        JoSiteWeather $weatherStation = this.getWeatherStation();
        result = result * 59 + ($weatherStation == null ? 43 : ((Object)$weatherStation).hashCode());
        return result;
    }

    public String toString() {
        return "JoSiteData(board1=" + this.getBoard1() + ", board2=" + this.getBoard2() + ", powerBoad=" + this.getPowerBoad() + ", netRelay1=" + this.getNetRelay1() + ", netRelay2=" + this.getNetRelay2() + ", weatherStation=" + this.getWeatherStation() + ")";
    }
}

