/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.data.param;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.geoway.fczx.jouav.data.JouavDevice;
import com.geoway.fczx.jouav.data.JouavPoint;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JouavTaskParam {
    private String name;
    private Integer waylineType;
    private Integer executeType;
    private Integer executeCycleNum;
    private String executeCycleTime;
    private Integer executeCycleType;
    private String executeStartTime;
    private List<JouavPoint> points;
    private JouavDevice device;

    public JouavTaskParam(String jobName, Object arg1, Object arg2, Object arg3, JSONArray rect) {
        JSONObject json = new JSONObject(arg1);
        JSONObject params = new JSONObject(arg2);
        JSONArray diagram = new JSONArray(arg3);
        if (ObjectUtil.isNotEmpty((Object)json)) {
            this.device = new JouavDevice();
            this.device.setUavModelId((Long)json.getByPath("childDevice.external.uavModelId", Long.class));
            this.device.setId((Long)json.getByPath("external.id", Long.class));
            this.device.setSiteSn(json.getStr((Object)"deviceSn"));
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.orbitRadius"))) {
                this.device.setOrbitRadius((Double)json.getByPath("metadata.orbitRadius", Double.class));
            }
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.orbitTime"))) {
                this.device.setOrbitTime((Float)json.getByPath("metadata.orbitTime", Float.class));
            }
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.visualAngle"))) {
                this.device.setViewAngle((Float)json.getByPath("metadata.visualAngle", Float.class));
            }
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.routeAngle"))) {
                this.device.setFrontalBearing((Double)json.getByPath("metadata.routeAngle", Double.class));
            }
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.photoHeight"))) {
                this.device.setRelativeHeight((Double)json.getByPath("metadata.photoHeight", Double.class));
            }
            if (ObjectUtil.isNotEmpty((Object)json.getByPath("metadata.manualFlightMinHeight"))) {
                this.device.setRelativeHeightMin((Double)json.getByPath("metadata.manualFlightMinHeight", Double.class));
            }
            if (this.device.getRelativeHeight() <= this.device.getRelativeHeightMin()) {
                this.device.setRelativeHeightMin(80.0);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)params)) {
            List arr;
            this.name = params.getStr((Object)"name");
            if (ObjectUtil.isEmpty((Object)this.name)) {
                this.name = jobName;
            }
            this.executeType = params.getInt((Object)"taskType");
            this.waylineType = params.getInt((Object)"waylineType");
            if (this.executeType == 1 && (arr = params.getJSONArray((Object)"taskDays").toList(Long.class)) != null && arr.size() == 1) {
                this.executeStartTime = DateUtil.formatDateTime((Date)new Date((Long)arr.get(0) * 1000L));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)diagram) && this.waylineType == 0) {
            this.points = new LinkedList<JouavPoint>();
            diagram.toList(JSONObject.class).forEach(p -> {
                JouavPoint point = new JouavPoint();
                point.setLongitude(p.getDouble((Object)"lon"));
                point.setLatitude(p.getDouble((Object)"lat"));
                point.setHeight(p.getDouble((Object)"altitude"));
                this.points.add(point);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)rect) && this.waylineType == 1) {
            this.points = new LinkedList<JouavPoint>();
            rect.toList(JouavPoint.class).forEach(p -> {
                p.setHeight(this.device.getRelativeHeight());
                this.points.add((JouavPoint)p);
            });
        }
    }

    public Map<String, Object> toTaskParam(String planNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executeStartTime", this.executeStartTime);
        map.put("executeCycleTime", this.executeCycleTime);
        map.put("executeCycleType", this.executeCycleType);
        map.put("executeCycleNum", this.executeCycleNum);
        map.put("executeType", this.executeType);
        map.put("planName", this.name);
        map.put("planNo", planNo);
        return map;
    }

    public String getName() {
        return this.name;
    }

    public Integer getWaylineType() {
        return this.waylineType;
    }

    public Integer getExecuteType() {
        return this.executeType;
    }

    public Integer getExecuteCycleNum() {
        return this.executeCycleNum;
    }

    public String getExecuteCycleTime() {
        return this.executeCycleTime;
    }

    public Integer getExecuteCycleType() {
        return this.executeCycleType;
    }

    public String getExecuteStartTime() {
        return this.executeStartTime;
    }

    public List<JouavPoint> getPoints() {
        return this.points;
    }

    public JouavDevice getDevice() {
        return this.device;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWaylineType(Integer waylineType) {
        this.waylineType = waylineType;
    }

    public void setExecuteType(Integer executeType) {
        this.executeType = executeType;
    }

    public void setExecuteCycleNum(Integer executeCycleNum) {
        this.executeCycleNum = executeCycleNum;
    }

    public void setExecuteCycleTime(String executeCycleTime) {
        this.executeCycleTime = executeCycleTime;
    }

    public void setExecuteCycleType(Integer executeCycleType) {
        this.executeCycleType = executeCycleType;
    }

    public void setExecuteStartTime(String executeStartTime) {
        this.executeStartTime = executeStartTime;
    }

    public void setPoints(List<JouavPoint> points) {
        this.points = points;
    }

    public void setDevice(JouavDevice device) {
        this.device = device;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JouavTaskParam)) {
            return false;
        }
        JouavTaskParam other = (JouavTaskParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$waylineType = this.getWaylineType();
        Integer other$waylineType = other.getWaylineType();
        if (this$waylineType == null ? other$waylineType != null : !((Object)this$waylineType).equals(other$waylineType)) {
            return false;
        }
        Integer this$executeType = this.getExecuteType();
        Integer other$executeType = other.getExecuteType();
        if (this$executeType == null ? other$executeType != null : !((Object)this$executeType).equals(other$executeType)) {
            return false;
        }
        Integer this$executeCycleNum = this.getExecuteCycleNum();
        Integer other$executeCycleNum = other.getExecuteCycleNum();
        if (this$executeCycleNum == null ? other$executeCycleNum != null : !((Object)this$executeCycleNum).equals(other$executeCycleNum)) {
            return false;
        }
        Integer this$executeCycleType = this.getExecuteCycleType();
        Integer other$executeCycleType = other.getExecuteCycleType();
        if (this$executeCycleType == null ? other$executeCycleType != null : !((Object)this$executeCycleType).equals(other$executeCycleType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$executeCycleTime = this.getExecuteCycleTime();
        String other$executeCycleTime = other.getExecuteCycleTime();
        if (this$executeCycleTime == null ? other$executeCycleTime != null : !this$executeCycleTime.equals(other$executeCycleTime)) {
            return false;
        }
        String this$executeStartTime = this.getExecuteStartTime();
        String other$executeStartTime = other.getExecuteStartTime();
        if (this$executeStartTime == null ? other$executeStartTime != null : !this$executeStartTime.equals(other$executeStartTime)) {
            return false;
        }
        List<JouavPoint> this$points = this.getPoints();
        List<JouavPoint> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        JouavDevice this$device = this.getDevice();
        JouavDevice other$device = other.getDevice();
        return !(this$device == null ? other$device != null : !((Object)this$device).equals(other$device));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JouavTaskParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $waylineType = this.getWaylineType();
        result = result * 59 + ($waylineType == null ? 43 : ((Object)$waylineType).hashCode());
        Integer $executeType = this.getExecuteType();
        result = result * 59 + ($executeType == null ? 43 : ((Object)$executeType).hashCode());
        Integer $executeCycleNum = this.getExecuteCycleNum();
        result = result * 59 + ($executeCycleNum == null ? 43 : ((Object)$executeCycleNum).hashCode());
        Integer $executeCycleType = this.getExecuteCycleType();
        result = result * 59 + ($executeCycleType == null ? 43 : ((Object)$executeCycleType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $executeCycleTime = this.getExecuteCycleTime();
        result = result * 59 + ($executeCycleTime == null ? 43 : $executeCycleTime.hashCode());
        String $executeStartTime = this.getExecuteStartTime();
        result = result * 59 + ($executeStartTime == null ? 43 : $executeStartTime.hashCode());
        List<JouavPoint> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        JouavDevice $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        return result;
    }

    public String toString() {
        return "JouavTaskParam(name=" + this.getName() + ", waylineType=" + this.getWaylineType() + ", executeType=" + this.getExecuteType() + ", executeCycleNum=" + this.getExecuteCycleNum() + ", executeCycleTime=" + this.getExecuteCycleTime() + ", executeCycleType=" + this.getExecuteCycleType() + ", executeStartTime=" + this.getExecuteStartTime() + ", points=" + this.getPoints() + ", device=" + this.getDevice() + ")";
    }
}

