/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.handler;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.geoway.fczx.djsk.data.SkBaseResult;
import com.geoway.fczx.jouav.data.JouavToken;
import com.geoway.fczx.jouav.data.property.JouavProperties;
import com.geoway.fczx.jouav.enmus.JouavRestApi;
import com.geoway.fczx.jouav.handler.AbstractJouavToFczxHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Component
public class JouavBaseHandler {
    private static final Logger log = LoggerFactory.getLogger(JouavBaseHandler.class);
    @Resource
    private RestTemplate jouavFhApiRest;
    @Resource
    private JouavProperties jouavProperties;
    @Autowired(required=false)
    private AbstractJouavToFczxHandler convertHandler;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static ConcurrentHashMap<String, JouavToken> tokenMap = new ConcurrentHashMap();

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public JouavToken getToken(String name) {
        if (tokenMap == null || tokenMap.get(name) == null || tokenMap.get(name).getTimestamp() + tokenMap.get(name).getExpiresIn() < System.currentTimeMillis()) {
            JouavToken token = this.requestToken();
            tokenMap.put(name, token);
            return token;
        }
        return tokenMap.get(name);
    }

    public JouavToken requestToken() {
        String server = this.getJouavProperties().getServerUrl();
        if (ObjectUtil.isEmpty((Object)server)) {
            log.error("\u7eb5\u6a2a\u63a5\u53e3\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u7eb5\u6a2a\u63a5\u53e3\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"username", (Object)this.getJouavProperties().getUsername());
        form.add((Object)"password", (Object)this.getJouavProperties().getPassword());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        String url = server.concat(JouavRestApi.loginToken.getUri());
        ResponseEntity res = this.jouavFhApiRest.postForEntity(url, (Object)new HttpEntity((Object)form, (MultiValueMap)headers), SkBaseResult.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<SkBaseResult>)res);
        if (!flag) {
            log.error("\u83b7\u53d6\u7eb5\u6a2a\u8ba4\u8bc1token\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (JouavToken)objectMapper.readValue(JSONUtil.toJsonStr(((SkBaseResult)res.getBody()).getData()), JouavToken.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T forwardJouavRequest(JouavRestApi api, Map<String, Object> params, Object body) {
        String server = this.getJouavProperties().getServerUrl();
        if (ObjectUtil.isEmpty((Object)server)) {
            log.error("\u7eb5\u6a2a\u63a5\u53e3\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
            throw new RuntimeException("\u7eb5\u6a2a\u63a5\u53e3\u8bbf\u95ee\u5730\u5740\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(api.getMedia());
        if (api.isBuildToken()) {
            headers.set("Authorization", this.getToken(this.getJouavProperties().getName()).getAuthorization());
        }
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = server.concat(api.getUri()).concat("?").concat(this.buildUrlParameters(params));
        try {
            log.debug("\u8f6c\u53d1\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42{}\n\u53c2\u6570\uff1a{}\nbody\uff1a{}", new Object[]{api.getUri(), JSONUtil.toJsonStr(params), JSONUtil.toJsonStr((Object)body)});
            ResponseEntity res = this.jouavFhApiRest.exchange(url, api.getMethod(), request, SkBaseResult.class, params);
            boolean flag = this.resolveResultBool((ResponseEntity<SkBaseResult>)res);
            if (BooleanUtil.isFalse((Boolean)flag)) {
                log.error("\u8f6c\u53d1\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42{}\u5931\u8d25\uff1a{}", (Object)api.getUri(), res.getBody());
                throw new RuntimeException("\u8f6c\u53d1\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
            }
            if (ObjectUtil.isNotEmpty(((SkBaseResult)res.getBody()).getData())) {
                if (api.isConvert()) {
                    return (T)objectMapper.readValue(JSONUtil.toJsonStr(((SkBaseResult)res.getBody()).getData()), api.getClazz());
                }
                return ((SkBaseResult)res.getBody()).getData();
            }
            return (T)Boolean.TRUE;
        }
        catch (HttpClientErrorException e) {
            if (e.getRawStatusCode() == 401) {
                JouavToken token = this.requestToken();
                tokenMap.put(this.getJouavProperties().getName(), token);
                return this.forwardJouavRequest(api, params, body);
            }
            throw e;
        }
        catch (JsonProcessingException e) {
            log.error("\u83b7\u53d6\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42{}\u89e3\u6790\u7ed3\u679c\u5931\u8d25\uff1a", (Object)api.getUri(), (Object)e);
            throw new RuntimeException("\u83b7\u53d6\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42\u89e3\u6790\u7ed3\u679c\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u8f6c\u53d1\u7eb5\u6a2a\u63a5\u53e3{}\u8bf7\u6c42\u5f02\u5e38\uff1a", (Object)api.getUri(), (Object)e);
            throw new RuntimeException("\u8f6c\u53d1\u7eb5\u6a2a\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    private boolean resolveResultBool(ResponseEntity<SkBaseResult> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            return Objects.requireNonNull((SkBaseResult)res.getBody()).getCode() == 200;
        }
        return false;
    }

    private String buildUrlParameters(Map<String, Object> map) {
        String parameters = "";
        if (ObjectUtil.isNotEmpty(map)) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!ObjectUtil.isNotEmpty((Object)map.get(key))) continue;
                args.add(key.concat("=").concat(map.get(key).toString()));
            }
            parameters = String.join((CharSequence)"&", args);
        }
        return parameters;
    }

    public JouavProperties getJouavProperties() {
        JSONObject config;
        if (this.convertHandler != null && (config = this.convertHandler.queryJouavConfig()) != null) {
            return (JouavProperties)config.toBean(JouavProperties.class);
        }
        return this.jouavProperties;
    }

    static {
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

