/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.handler;

import com.geoway.ue.common.constant.ResultCode;
import com.geoway.ue.common.data.response.BaseResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpClientErrorException;

@ControllerAdvice(basePackages={"com.geoway.fczx.jouav"})
public class JouavExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JouavExceptionHandler.class);

    @ExceptionHandler(value={HttpClientErrorException.class})
    @ResponseBody
    public ResponseEntity<BaseResponse> doHttpClientErrorException(HttpServletRequest request, HttpClientErrorException e) {
        log.error(">>>url={}\u4e0a\u4f20\u53d1\u751f\u5f02\u5e38", (Object)request.getRequestURI(), (Object)e);
        return BaseResponse.error((String)e.getStatusText(), (int)e.getRawStatusCode());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    public ResponseEntity<BaseResponse> doRuntimeExceptionHandle(HttpServletRequest request, Exception e) {
        log.error(">>>\u8bf7\u6c42url={}\u53d1\u751f\u5f02\u5e38", (Object)request.getRequestURI(), (Object)e);
        return BaseResponse.error((ResultCode)ResultCode.C500);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResponseEntity<BaseResponse> doExceptionHandle(HttpServletRequest request, Exception e) {
        log.error(">>>\u8bf7\u6c42url={}\u53d1\u751f\u5f02\u5e38", (Object)request.getRequestURI(), (Object)e);
        return BaseResponse.error((ResultCode)ResultCode.C500);
    }
}

