/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.fczx.jouav.restful;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.fczx.jouav.data.JouavLiveUrl;
import com.geoway.fczx.jouav.data.JouavStream;
import com.geoway.fczx.jouav.data.param.JouavMissionDto;
import com.geoway.fczx.jouav.data.param.JouavTaskParam;
import com.geoway.fczx.jouav.service.JoFlightService;
import com.geoway.ue.common.data.response.OpRes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class JoFhRestService {
    private static final Logger log = LoggerFactory.getLogger(JoFhRestService.class);
    @Resource
    private JoFlightService flightService;
    @Resource
    private Environment environment;

    public OpRes<Object> startLive(String sn, Integer type) {
        Object res = this.flightService.obtainDeviceLive(sn, type);
        if (res != null) {
            JSONObject json = new JSONObject(res);
            if (res instanceof JouavStream) {
                json.putOpt("hls_pull_url", (Object)((JouavStream)res).getHlsPullUrl());
                json.putOpt("rtmp_pull_url", (Object)((JouavStream)res).getRtmpPullUrl());
                json.putOpt("http_pull_url", (Object)((JouavStream)res).getHttpPullUrl());
                json.putOpt("rtc_pull_url", (Object)((JouavStream)res).getRtcPullUrl());
            } else if (res instanceof JouavLiveUrl) {
                json.putOpt("hls_pull_url", (Object)((JouavLiveUrl)res).getHlsPullUrl());
                json.putOpt("rtmp_pull_url", (Object)((JouavLiveUrl)res).getRtmpPullUrl());
                json.putOpt("http_pull_url", (Object)((JouavLiveUrl)res).getHttpPullUrl());
                json.putOpt("rtc_pull_url", (Object)((JouavLiveUrl)res).getRtcPullUrl());
            }
            json.putOpt("provider", (Object)this.flightService.getLiveProvider());
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
            map.put("channel_info", json);
            return new OpRes(null, map, true);
        }
        return new OpRes("\u5f00\u542f\u76f4\u64ad\u5931\u8d25", null, false);
    }

    public OpRes<List<String>> makeFlightNow(JouavTaskParam param) {
        log.info("\u7eb5\u6a2a\u4efb\u52a1\u8d77\u98de{}", (Object)param);
        if (ObjectUtil.isNotEmpty(param.getPoints())) {
            OpRes<JouavMissionDto> data = this.flightService.generatingRoute(param.getName(), param.getWaylineType(), param.getDevice(), param.getPoints());
            log.debug("{}", (Object)JSONUtil.toJsonPrettyStr((Object)((JouavMissionDto)data.getData()).getRouteJson()));
            if (!data.isOpRes()) {
                return new OpRes(data.getErrorDesc(), null, false);
            }
            if (!BooleanUtil.isTrue((Boolean)((Boolean)this.environment.getProperty("com.geoway.fczx.debug.jouav-debug-route", Boolean.class)))) {
                OpRes<Boolean> flag = this.flightService.executePlan(((JouavMissionDto)data.getData()).getPlanNo(), param.getExecuteType(), param);
                return new OpRes(flag.getErrorDesc(), ObjectUtil.isEmpty((Object)data.getData()) ? null : Collections.singletonList(((JouavMissionDto)data.getData()).getPlanNo()), flag.isOpRes());
            }
        }
        return new OpRes("", null, false);
    }
}

