/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.tenant.constant.TenantConst;
import com.geoway.tenant.data.LoginTenant;
import com.geoway.tenant.data.LoginUser;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.data.TenantUserPWd;
import com.geoway.tenant.exception.TenantException;
import com.geoway.tenant.handler.TenantRedisHander;
import com.geoway.tenant.thirdapi.UisRestService;
import com.geoway.tenant.util.TenantUtil;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.env.Environment;

public abstract class AbstractTenantService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTenantService.class);
    @Resource
    private Environment environment;
    @Resource
    private UisRestService uisRestService;
    @Resource
    private TenantRedisHander redisHander;
    @Resource
    private ServerProperties serverProperties;
    @Resource
    private MultiTenantProperties tenantProperties;

    public abstract TenantUserPWd getTenantUserPWd(String var1);

    public abstract boolean loadAllTenantDevices();

    public String getDeviceTenant(String deviceSn) {
        if (this.redisHander.checkExist("tenant:" + deviceSn)) {
            return deviceSn;
        }
        return this.redisHander.get("tenant_device:" + deviceSn);
    }

    public String getTenantIdByToken(String tenantToken) {
        return this.redisHander.get("token:" + tenantToken);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existByToken(String tenantToken, String url, String tenant, String tenantKey, String isInternal) {
        if (BooleanUtil.isFalse((Boolean)this.tenantProperties.getEnableSsoAuthTest())) {
            TenantUtil.setTenantId(tenantToken);
            return true;
        }
        if (ObjectUtil.contains(TenantConst.IGNORE_TENANT_PATHS, (Object)url.replaceFirst(this.serverProperties.getServlet().getContextPath(), ""))) {
            return true;
        }
        if (ObjectUtil.isNotEmpty((Object)tenant)) {
            if (!this.redisHander.checkExist("tenant:" + tenant)) return false;
            OpRes<LoginTenant> res = this.uisRestService.getTenantInfo(tenant);
            if (!res.isOpRes()) return false;
            if (res.getData() == null) return false;
            if (!ObjectUtil.equal((Object)0, (Object)((LoginTenant)res.getData()).getAuth())) return false;
            log.debug("\u65e0\u9700\u8ba4\u8bc1{}", (Object)tenant);
            TenantUtil.setTenantId(tenant);
            return true;
        }
        SaTokenInfo token = StpUtil.getTokenInfo();
        if (!ObjectUtil.equal((Object)"x-tenant-key", (Object)tenantKey) && ObjectUtil.isEmpty((Object)isInternal)) {
            try {
                TenantUtil.setTenantUser((String)StpUtil.getLoginId());
                log.debug("\u7eed\u7ea6uis token\u4fe1\u606f{}\uff0c{}", (Object)token, StpUtil.getLoginId());
            }
            catch (NotLoginException e) {
                this.redisHander.del("token:" + tenantToken);
                return false;
            }
        }
        if (BooleanUtil.isFalse((Boolean)token.getIsLogin()) && ObjectUtil.isEmpty((Object)tenantKey)) {
            this.redisHander.del("token:" + tenantToken);
            return false;
        }
        if (this.redisHander.checkExist("token:" + tenantToken)) {
            String tenantId = this.redisHander.get("token:" + tenantToken);
            TenantUtil.setTenantId(tenantId);
            return true;
        }
        OpRes<LoginUser> res = this.uisRestService.getCurrentTenants(tenantToken);
        if (res.isOpRes() && res.getData() != null) {
            String tenantId = ((LoginUser)res.getData()).getCurrentTenantId();
            if (ObjectUtil.isEmpty((Object)tenantId)) {
                log.error("\u6839\u636e\u5355\u70b9\u767b\u5f55token{}\u83b7\u53d6\u79df\u6237\u4fe1\u606f{}\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u79df\u6237\u4fe1\u606f", (Object)tenantToken, res.getData());
                throw new TenantException("\u6839\u636e\u5355\u70b9\u767b\u5f55token\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u79df\u6237\u4fe1\u606f", 417);
            }
            TenantUtil.setTenantId(tenantId);
            boolean flag = this.redisHander.checkExist("tenant:" + tenantId);
            if (!flag) throw new TenantException("\u4e0d\u662f\u6b64\u5e94\u7528\u7684\u79df\u6237\uff0c\u65e0\u6cd5\u8bbf\u95ee", 403);
            this.redisHander.setWithExpire("token:" + tenantToken, tenantId, token.getTokenTimeout());
            return true;
        }
        log.error("\u6839\u636e\u5355\u70b9\u767b\u5f55token{}\u83b7\u53d6\u79df\u6237\u7528\u6237\u4fe1\u606f{}\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object)tenantToken, res.getData());
        throw new TenantException("\u6839\u636e\u5355\u70b9\u767b\u5f55token\u83b7\u53d6\u79df\u6237\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", 500);
    }

    public abstract String getWorkspaceIdBySn(Object[] var1);

    public TenantUserPWd getTenantInfo() {
        SaTokenInfo token = StpUtil.getTokenInfo();
        if (BooleanUtil.isFalse((Boolean)token.getIsLogin())) {
            throw new TenantException("\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u4fe1\u606f\u8fc7\u671f", 401);
        }
        StringBuilder addr = new StringBuilder().append("tcp://").append(this.environment.getProperty("mqtt.BASIC.host")).append(":").append(this.environment.getProperty("mqtt.BASIC.port"));
        TenantUserPWd tenant = new TenantUserPWd();
        tenant.setMqttAddr(addr.toString());
        tenant.setAccessToken(token.getTokenValue());
        tenant.setUserId((String)token.getLoginId());
        tenant.setWorkspaceId(TenantUtil.getTenantId());
        tenant.setUsername((String)token.getLoginId());
        tenant.setMqttUsername((String)token.getLoginId());
        tenant.setPassword(this.tenantProperties.getPilotMqttPwd());
        tenant.setMqttPassword(this.tenantProperties.getPilotMqttPwd());
        tenant.setWorkspaceUuid(TenantUtil.uuidFmt(tenant.getWorkspaceId()));
        if (ObjectUtil.isNotEmpty((Object)this.tenantProperties.getPilotMqttUrl())) {
            tenant.setMqttAddr(this.tenantProperties.getPilotMqttUrl());
        }
        return tenant;
    }

    public OpRes<List<LoginTenant>> getCurrentTenants() {
        OpRes<LoginUser> res = this.uisRestService.getCurrentTenants(StpUtil.getTokenValue());
        if (!res.isOpRes()) {
            return new OpRes(res.getErrorDesc(), null, false);
        }
        List<Object> list = new ArrayList();
        if (ObjectUtil.isAllNotEmpty((Object[])new Object[]{res.getData(), ((LoginUser)res.getData()).getTenants()})) {
            list = ((LoginUser)res.getData()).getTenants().stream().filter(data -> ObjectUtil.equal((Object)data.getAppId(), (Object)this.tenantProperties.getUisDroneAppId())).collect(Collectors.toList());
        }
        return new OpRes(null, list, true);
    }

    public boolean switchTenant(String tenantId) {
        boolean flag = this.uisRestService.switchTenant(StpUtil.getTokenValue(), tenantId);
        if (flag) {
            this.redisHander.setWithExpire("token:" + StpUtil.getTokenValue(), tenantId, StpUtil.getTokenTimeout());
        }
        return flag;
    }

    public Object forwardTenant(HttpServletRequest request, Map<String, Object> params, Map<String, Object> body) {
        String url = request.getRequestURI();
        int loc = url.lastIndexOf("/uis3") + "/uis3".length();
        return this.uisRestService.forwardTenantRequest(StpUtil.getTokenValue(), url.substring(loc), params, body, request.getMethod());
    }
}

