/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.handler;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.data.MutableHttpServletRequest;
import com.geoway.tenant.exception.TenantException;
import com.geoway.tenant.handler.AbstractTenantService;
import com.geoway.tenant.util.TenantUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@Order(value=1)
public class HttpTenantIdHandler
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpTenantIdHandler.class);
    private AbstractTenantService tenantService;
    private MultiTenantProperties tenantProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Cookie[] cookies;
        String workId;
        Map pathVariables;
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setStatus(HttpStatus.OK.value());
            return false;
        }
        if (this.tenantProperties.getChangeWorkspaceId().booleanValue() && (pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)) != null && pathVariables.containsKey("workspace_id") && ObjectUtil.isNotEmpty((Object)(workId = (String)pathVariables.get("workspace_id"))) && ObjectUtil.contains((Object)workId, (Object)"-")) {
            MutableHttpServletRequest mutableRequest = new MutableHttpServletRequest(request);
            pathVariables.forEach(mutableRequest::setPathVariable);
            mutableRequest.setPathVariable("workspace_id", workId.replaceAll("-", ""));
            request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, mutableRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
        }
        String tenantKey = request.getHeader("x-tenant-key");
        String token = request.getHeader(this.tenantProperties.getHeaderTokenKey());
        if (ObjectUtil.isEmpty((Object)token)) {
            token = request.getParameter(this.tenantProperties.getHeaderTokenKey());
        }
        if (ObjectUtil.isEmpty((Object)token) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!ObjectUtil.equal((Object)this.tenantProperties.getHeaderTokenKey(), (Object)cookie.getName())) continue;
                token = cookie.getValue();
            }
        }
        String restTenant = null;
        if (ObjectUtil.isEmpty((Object)token)) {
            restTenant = request.getHeader("x-tenant-id");
        }
        String appTenant = request.getHeader("x-tenant-app");
        if (ObjectUtil.isEmpty((Object)token) && ObjectUtil.isNotEmpty((Object)appTenant)) {
            tenantKey = "x-tenant-app";
            token = appTenant;
        }
        if (ObjectUtil.isEmpty((Object)token) && ObjectUtil.isEmpty((Object)restTenant) && ObjectUtil.isEmpty((Object)appTenant)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            this.responseError(response, "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String url = request.getRequestURI();
        try {
            if (!this.tenantService.existByToken(token, request.getRequestURI(), restTenant, tenantKey, appTenant)) {
                this.printHeaders(request);
                log.error("{}\u79df\u6237\u4fe1\u606f\u672a\u627e\u5230\u6216token\u8fc7\u671f", (Object)url);
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                this.responseError(response, "\u79df\u6237\u4fe1\u606f\u672a\u627e\u5230\u6216token\u8fc7\u671f");
                return false;
            }
        }
        catch (HttpClientErrorException.Unauthorized e) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            this.responseError(response, "\u79df\u6237\u4fe1\u606f\u672a\u627e\u5230\u6216token\u8fc7\u671f");
            return false;
        }
        catch (TenantException e) {
            log.error("{}{}", (Object)url, (Object)e.getError());
            response.setStatus(e.getCode());
            this.responseError(response, e.getError());
            return false;
        }
        TenantUtil.setTenantToken(token);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        TenantUtil.setTenantId(null);
        TenantUtil.setTenantUser(null);
    }

    public void responseError(HttpServletResponse response, String error) {
        try {
            JSONObject data = new JSONObject();
            data.putOpt("status", (Object)"error");
            data.putOpt("message", (Object)error);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            IoUtil.copy((InputStream)new ByteArrayInputStream(data.toString().getBytes(StandardCharsets.UTF_8)), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public void printHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        log.debug("headers:{}", headers);
    }

    public HttpTenantIdHandler(AbstractTenantService tenantService, MultiTenantProperties tenantProperties) {
        this.tenantService = tenantService;
        this.tenantProperties = tenantProperties;
    }
}

