/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.util.SqlUtil;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSchemaInterceptor
implements TableNameHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicSchemaInterceptor.class);
    private MultiTenantProperties tenantProperties;

    public String dynamicTableName(String sql, String tableName) {
        Set<String> tableNames = SqlUtil.getTableListName(sql);
        log.debug("\u653e\u5f00{}\n{}", this.tenantProperties.getNonTenantTables(), (Object)tableName);
        if (!this.isPlatform(tableNames) && this.tenantProperties.getNonTenantTables().contains(tableName)) {
            return "public." + tableName;
        }
        return tableName;
    }

    private static SqlCommandType getSqlCommandType(StatementHandler handler) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)handler);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType type = ms.getSqlCommandType();
        log.info("\u64cd\u4f5c\u7c7b\u578b{}", (Object)type);
        return type;
    }

    public boolean isPlatform(Set<String> tableName) {
        return CollectionUtil.containsAll(this.tenantProperties.getNonTenantTables(), tableName);
    }

    public DynamicSchemaInterceptor(MultiTenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

