/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.interceptor;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.geoway.tenant.handler.TenantRedisHander;
import com.geoway.tenant.util.TenantUtil;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestRequestInterceptor.class);
    private String tokenKeyName;
    private TenantRedisHander redisHander;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            HttpHeaders headers = request.getHeaders();
            String token = headers.getFirst(this.tokenKeyName);
            if (ObjectUtil.isEmpty((Object)token)) {
                token = TenantUtil.getTenantToken();
                if (ObjectUtil.isEmpty((Object)TenantUtil.getTenantToken()) && ObjectUtil.isNotEmpty((Object)TenantUtil.getTenantId())) {
                    token = IdUtil.fastSimpleUUID();
                    headers.add("x-tenant-app", token);
                    this.redisHander.setWithExpire("token:" + token, TenantUtil.getTenantId(), 30L);
                }
                headers.put(this.tokenKeyName, Collections.singletonList(token));
            }
            headers.add("x-tenant-key", this.tokenKeyName);
            log.debug("{}\u8bbe\u7f6e\u8f6c\u53d1\u8bf7\u6c42\u5934{}\n\u8bf7\u6c42\u53c2\u6570{}", new Object[]{request.getURI(), headers, new String(body)});
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6erestTemplateToken\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return execution.execute(request, body);
    }

    public RestRequestInterceptor(String tokenKeyName, TenantRedisHander redisHander) {
        this.tokenKeyName = tokenKeyName;
        this.redisHander = redisHander;
    }
}

