/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.thirdapi;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.tenant.data.LoginTenant;
import com.geoway.tenant.data.LoginUser;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.data.SsoToken;
import com.geoway.tenant.exception.TenantException;
import com.geoway.ue.common.data.response.OpRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class UisRestService {
    private static final Logger log = LoggerFactory.getLogger(UisRestService.class);
    @Resource
    private RestTemplate ygbApiRest;
    @Resource
    private MultiTenantProperties tenantProperties;
    private static final String verifyTokenUrl = "/sso/getTokenInfo";
    private static final String obtainTenantUrl = "/sys/currentTenant";
    private static final String switchTenantUrl = "/sys/switchTenantById?tenantId=";
    private static final String getTenantUserUrl = "/sys/userinfo";
    private static final String getTenantInfoUrl = "/tenant/findById?id=";

    @PostConstruct
    public void initUisService() {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isNotEmpty((Object)uis3Server)) {
            log.warn("\u5df2\u5f00\u542fSAAS\uff0c\u8bf7\u786e\u4fddUIS3\u670d\u52a1{}\u6b63\u5e38\u53ef\u7528", (Object)uis3Server);
        }
    }

    public OpRes<LoginTenant> obtainTenant(String token, Object loginId) {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isEmpty((Object)uis3Server)) {
            return new OpRes("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5", null, false);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("username", loginId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(this.tenantProperties.getHeaderTokenKey(), token);
        HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
        String url = uis3Server.concat(obtainTenantUrl);
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", res.getBody());
            return new OpRes("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)((LoginTenant)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data", LoginTenant.class)), true);
    }

    public OpRes<SsoToken> verifyToken(String token) {
        String ssoServer = this.tenantProperties.getSsoServer();
        if (ObjectUtil.isEmpty((Object)ssoServer)) {
            return new OpRes("\u79df\u6237Token\u6821\u9a8c\u8ba4\u8bc1\u672a\u77e5", null, false);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(this.tenantProperties.getHeaderTokenKey(), token);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = ssoServer.concat(verifyTokenUrl);
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u79df\u6237Token\u6821\u9a8c\u8ba4\u8bc1\u672a\u77e5\u5931\u8d25\uff1a{}", res.getBody());
            return new OpRes("\u79df\u6237Token\u6821\u9a8c\u8ba4\u8bc1\u672a\u77e5\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)((SsoToken)JSONUtil.parseObj((String)((String)res.getBody())).toBean(SsoToken.class)), true);
    }

    public OpRes<LoginUser> getCurrentTenants(String token) {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isEmpty((Object)uis3Server)) {
            return new OpRes("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5", null, false);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(this.tenantProperties.getHeaderTokenKey(), token);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        String url = uis3Server.concat(getTenantUserUrl);
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u5217\u8868\u5931\u8d25\uff1a{}", res.getBody());
            return new OpRes("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u5217\u8868\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)((LoginUser)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data", LoginUser.class)), true);
    }

    public OpRes<LoginTenant> getTenantInfo(String tenantId) {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isEmpty((Object)uis3Server)) {
            return new OpRes("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5", null, false);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = uis3Server.concat(getTenantInfoUrl).concat(tenantId);
        HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", res.getBody());
            return new OpRes("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25", null, false);
        }
        return new OpRes(null, (Object)((LoginTenant)JSONUtil.parseObj((String)((String)res.getBody())).getByPath("data", LoginTenant.class)), true);
    }

    public boolean switchTenant(String token, String tenantId) {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isEmpty((Object)uis3Server)) {
            log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5");
            return false;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set(this.tenantProperties.getHeaderTokenKey(), token);
        HttpEntity request = new HttpEntity(param, (MultiValueMap)headers);
        String url = uis3Server.concat(switchTenantUrl).concat(tenantId);
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.GET, request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u5207\u6362\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", res.getBody());
            return false;
        }
        return flag;
    }

    public Object forwardTenantRequest(String token, String base, Map<String, Object> params, Map<String, Object> body, String method) {
        String uis3Server = this.tenantProperties.getUis3Server();
        if (ObjectUtil.isEmpty((Object)uis3Server)) {
            log.error("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5");
            throw new TenantException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u670d\u52a1\u672a\u77e5");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (HttpMethod.GET.name().equalsIgnoreCase(method)) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        headers.set(this.tenantProperties.getHeaderTokenKey(), token);
        HttpEntity request = new HttpEntity(body, (MultiValueMap)headers);
        String url = uis3Server.concat(base).concat("?").concat(this.buildUrlParameters(params));
        ResponseEntity res = this.ygbApiRest.exchange(url, HttpMethod.resolve((String)method), request, String.class, new Object[0]);
        boolean flag = this.resolveResultBool((ResponseEntity<String>)res);
        if (BooleanUtil.isFalse((Boolean)flag)) {
            log.error("\u8f6c\u53d1UIS\u79df\u6237\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25\uff1a{}", res.getBody());
            throw new TenantException("\u8f6c\u53d1UIS\u79df\u6237\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readValue((String)res.getBody(), Object.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean resolveResultBool(ResponseEntity<String> res) {
        if (ObjectUtil.equal((Object)res.getStatusCode(), (Object)HttpStatus.OK) && ObjectUtil.isNotEmpty((Object)res.getBody())) {
            int code = JSONUtil.parseObj((String)((String)res.getBody())).getInt((Object)"code");
            return code == 200;
        }
        return false;
    }

    private String buildUrlParameters(Map<String, Object> map) {
        String parameters = "";
        if (ObjectUtil.isNotEmpty(map)) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : map.keySet()) {
                if (!ObjectUtil.isNotEmpty((Object)map.get(key))) continue;
                args.add(key.concat("=").concat(map.get(key).toString()));
            }
            parameters = String.join((CharSequence)"&", args);
        }
        return parameters;
    }
}

