/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.tenant.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.tenant.data.MultiTenantProperties;
import com.geoway.tenant.data.TenantUserPWd;
import com.geoway.tenant.handler.AbstractTenantService;
import com.geoway.ue.common.util.SpringTool;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantUtil {
    private static final Logger log = LoggerFactory.getLogger(TenantUtil.class);
    private static final ThreadLocal<String> TENANT_ID_THREAD_LOCAL = new NamedInheritableThreadLocal("TENANT_ID_THREAD_LOCAL");
    private static final ThreadLocal<String> TENANT_USER_THREAD_LOCAL = new NamedInheritableThreadLocal("TENANT_USER_THREAD_LOCAL");
    private static final ThreadLocal<String> TENANT_TOKEN_THREAD_LOCAL = new NamedInheritableThreadLocal("TENANT_TOKEN_THREAD_LOCAL");

    public static String getTenantId() {
        log.debug("\u79df\u6237" + Thread.currentThread().getName());
        if (ObjectUtil.isNotEmpty((Object)TENANT_ID_THREAD_LOCAL.get())) {
            return TENANT_ID_THREAD_LOCAL.get();
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(attributes)) {
            return null;
        }
        MultiTenantProperties tenantProperties = (MultiTenantProperties)SpringTool.getBean(MultiTenantProperties.class);
        HttpServletRequest request = attributes.getRequest();
        String header = request.getHeader(tenantProperties.getHeaderTokenKey());
        if (StrUtil.isNotBlank((CharSequence)header)) {
            return header;
        }
        header = request.getParameter(tenantProperties.getHeaderTokenKey());
        if (StrUtil.isNotBlank((CharSequence)header)) {
            return header;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!ObjectUtil.equal((Object)tenantProperties.getHeaderTokenKey(), (Object)cookie.getName())) continue;
                header = cookie.getValue();
            }
        }
        return header;
    }

    public static TenantUserPWd getTenantUserPWd() {
        AbstractTenantService tenantService = (AbstractTenantService)SpringTool.getBean(AbstractTenantService.class);
        return tenantService.getTenantUserPWd(TenantUtil.getTenantId());
    }

    public static void setTenantId(String tenantId) {
        log.debug("\u79df\u6237" + tenantId);
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            TENANT_ID_THREAD_LOCAL.set(tenantId);
        } else {
            TENANT_ID_THREAD_LOCAL.remove();
        }
    }

    public static String getTenantToken() {
        if (ObjectUtil.isNotEmpty((Object)TENANT_TOKEN_THREAD_LOCAL.get())) {
            return TENANT_TOKEN_THREAD_LOCAL.get();
        }
        return null;
    }

    public static String getTenantUser() {
        if (ObjectUtil.isNotEmpty((Object)TENANT_USER_THREAD_LOCAL.get())) {
            return TENANT_USER_THREAD_LOCAL.get();
        }
        return null;
    }

    public static void setTenantToken(String tenantToken) {
        if (ObjectUtil.isNotEmpty((Object)tenantToken)) {
            TENANT_TOKEN_THREAD_LOCAL.set(tenantToken);
        } else {
            TENANT_TOKEN_THREAD_LOCAL.remove();
        }
    }

    public static void setTenantUser(String user) {
        log.debug("\u7528\u6237" + user);
        if (ObjectUtil.isNotEmpty((Object)user)) {
            TENANT_USER_THREAD_LOCAL.set(user);
        } else {
            TENANT_USER_THREAD_LOCAL.remove();
        }
    }

    public static String uuidFmt(String tenantId) {
        String fmt = "%s-%s-%s-%s-%s";
        if (ObjectUtil.isNotEmpty((Object)tenantId)) {
            if (ObjectUtil.contains((Object)tenantId, (Object)"-")) {
                return tenantId;
            }
            return String.format(fmt, tenantId.substring(0, 8), tenantId.substring(8, 12), tenantId.substring(12, 16), tenantId.substring(16, 20), tenantId.substring(20, 32));
        }
        return null;
    }
}

