/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller;

import com.alibaba.fastjson.JSONObject;
import com.geoway.drone.model.dto.DroneReportVo;
import com.geoway.drone.serface.AppConfigService;
import com.geoway.drone.serface.AppPermissionService;
import com.geoway.drone.serface.AppServerService;
import com.geoway.drone.serface.DroneInfoService;
import com.geoway.drone.serface.DroneSubmitService;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.Drone;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.DroneRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.gw.base.data.result.GiResult;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/dronecenter/api"})
public class ApiController {
    @Autowired
    AppServerService appServerService;
    @Autowired
    AppConfigService appConfigService;
    @Autowired
    AppPermissionService appPermissionService;
    @Autowired
    DroneInfoService droneService;
    @Resource
    AppMediaRepository appMediaRepository;
    @Resource
    DroneRepository droneRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    DroneSubmitService submitService;

    @RequestMapping(value={"/drone/reportLocation"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> reportLocation(HttpServletRequest request, @ModelAttribute DroneReportVo reportVo) {
        this.droneService.report(reportVo);
        return GiResult.success();
    }

    @RequestMapping(value={"/drone/submitter"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> submitter(HttpServletRequest request) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile file = multipartRequest.getFile("file");
        String id = multipartRequest.getParameter("id");
        String tbid = multipartRequest.getParameter("tbid");
        String viewurl = multipartRequest.getParameter("viewurl");
        String format = multipartRequest.getParameter("format");
        String downloadurl = multipartRequest.getParameter("downloadurl");
        String tag = multipartRequest.getParameter("tag");
        String appkey = multipartRequest.getParameter("appkey");
        String keymetadatas = multipartRequest.getParameter("keymetadatas");
        String jym = multipartRequest.getParameter("jym");
        String scale = multipartRequest.getParameter("scale");
        String othermetadatas = multipartRequest.getParameter("othermetadatas");
        String takeOffLon = multipartRequest.getParameter("takeOffLon");
        String takeOffLat = multipartRequest.getParameter("takeOffLat");
        String takeOffRelHeight = multipartRequest.getParameter("takeOffRelHeight");
        String token = multipartRequest.getParameter("token");
        String bizId = multipartRequest.getParameter("bizId");
        String f35mmfocal = multipartRequest.getParameter("35mmfocal");
        String dimwidth = multipartRequest.getParameter("dimwidth");
        String dimheight = multipartRequest.getParameter("dimheight");
        String sm3 = multipartRequest.getParameter("sm3");
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new RuntimeException("token\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Drone drone = new Drone();
        AppMedia appMedia = new AppMedia();
        if (StringUtils.isBlank((CharSequence)id)) {
            id = UUID.randomUUID().toString();
        }
        if (file != null) {
            String key = String.format("taskthird/%s/%s.%s", tbid, UUID.randomUUID().toString(), format);
            viewurl = this.defaultOssOperatorService.sendObject2Oss(key, file.getInputStream());
        }
        drone.setId(id);
        drone.setJctbid(tbid);
        drone.setViewurl(viewurl);
        drone.setFormat(format);
        drone.setDownloadurl(downloadurl);
        drone.setAppkey(appkey);
        drone.setCreatetime(new Date());
        drone.setTag(tag);
        drone.setScale(scale);
        drone.setJym(jym);
        drone.setOthermetadatas(othermetadatas);
        appMedia.setId(id);
        appMedia.setGalleryid(tbid);
        appMedia.setServerpath(viewurl);
        appMedia.setDownloadUrl(downloadurl);
        appMedia.setAppKey(appkey);
        appMedia.setCreateTime(String.valueOf(System.currentTimeMillis()));
        appMedia.setScale(scale);
        appMedia.setJym(jym);
        appMedia.setDeviceSource(Integer.valueOf(1));
        appMedia.setBizId(bizId);
        appMedia.setSm3(sm3);
        if (StringUtils.isNumeric((CharSequence)dimheight)) {
            appMedia.setDimHeight(Integer.valueOf(dimheight));
        }
        if (StringUtils.isNumeric((CharSequence)dimwidth)) {
            appMedia.setDimWidth(Integer.valueOf(dimwidth));
        }
        if (StringUtils.isNumeric((CharSequence)f35mmfocal)) {
            appMedia.setF35mmfocal(Integer.valueOf(f35mmfocal));
        }
        if (StringUtils.isNotBlank((CharSequence)format)) {
            if ("jpg".equalsIgnoreCase(format)) {
                appMedia.setType(Integer.valueOf(1));
            } else if ("mp4".equalsIgnoreCase(format)) {
                appMedia.setType(Integer.valueOf(2));
            } else if ("mp3".equalsIgnoreCase(format)) {
                appMedia.setType(Integer.valueOf(3));
            } else if ("osgb".equalsIgnoreCase(format)) {
                appMedia.setType(Integer.valueOf(4));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            appMedia.setTypetype(Integer.valueOf(tag));
        }
        appMedia.setMetaInfo(othermetadatas);
        if (StringUtils.isNumeric((CharSequence)takeOffLon)) {
            drone.setTakeOffLon(Float.parseFloat(takeOffLon));
            appMedia.setTakeOffLon(Double.valueOf(Double.parseDouble(takeOffLon)));
        }
        if (StringUtils.isNumeric((CharSequence)takeOffLat)) {
            drone.setTakeOffLat(Float.parseFloat(takeOffLat));
            appMedia.setTakeOffLat(Double.valueOf(Double.parseDouble(takeOffLon)));
        }
        if (StringUtils.isNumeric((CharSequence)takeOffRelHeight)) {
            drone.setTakeOffRelHeight(Float.parseFloat(takeOffRelHeight));
            appMedia.setTakeOffHeight(Double.valueOf(Double.parseDouble(takeOffRelHeight)));
        }
        JSONObject jsonObject = null;
        if (StringUtils.isNotBlank((CharSequence)keymetadatas) && (jsonObject = JSONObject.parseObject((String)keymetadatas)) != null) {
            Float psfyj;
            Float height;
            Float latitude;
            Float longitude;
            Float psjd;
            String psry;
            String pssj = jsonObject.getString("pssj");
            if (StringUtils.isNotBlank((CharSequence)pssj)) {
                SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                drone.setPssj(format1.parse(pssj));
                appMedia.setTime(format1.parse(pssj).getTime() + "");
            }
            if (StringUtils.isNotBlank((CharSequence)(psry = jsonObject.getString("psry")))) {
                drone.setPsry(psry);
                appMedia.setUsername(psry);
            }
            if ((psjd = jsonObject.getFloat("psjd")) != null) {
                drone.setPsjd(psjd);
                appMedia.setAzimuth(jsonObject.getString("psjd"));
            }
            if ((longitude = jsonObject.getFloat("longitude")) != null) {
                drone.setLongitude(longitude);
                appMedia.setLon(jsonObject.getDouble("longitude"));
            }
            if ((latitude = jsonObject.getFloat("latitude")) != null) {
                drone.setLatitude(latitude);
                appMedia.setLat(jsonObject.getDouble("latitude"));
            }
            if ((height = jsonObject.getFloat("height")) != null) {
                drone.setPsgd(height.floatValue());
                appMedia.setPsgd(jsonObject.getDouble("height"));
            }
            if ((psfyj = jsonObject.getFloat("psfyj")) != null) {
                drone.setPsfyj(psfyj.floatValue());
                appMedia.setPitch(jsonObject.getString("psfyj"));
            }
        }
        this.droneRepository.save((Object)drone);
        this.appMediaRepository.save((Object)appMedia);
        this.submitService.submit(JSONObject.toJSONString((Object)appMedia));
        return GiResult.successValue((Object)id);
    }

    @RequestMapping(value={"/drone/getLiveUrl.json"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiResult<?> getLiveUrl(HttpServletRequest request, @RequestParam(value="sn", required=true) String sn, @RequestParam(value="appkey", required=false) String appkey) {
        return GiResult.successValue((Object)this.droneService.getLiveUrl(sn, appkey));
    }
}

