/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.controller.config;

import com.geoway.drone.controller.interceptor.LoginInterceptor;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfig
implements WebMvcConfigurer {
    @Resource
    RedisTemplate redisTemplate;
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/**", "classpath:/static/", "classpath:/public/", "classpath:/templates/"};

    @Bean
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("/dronecenter/third/login");
        excludes.add("/dronecenter/third/loginByPhone.action");
        excludes.add("/dronecenter/third/verifyToken");
        excludes.add("/dronecenter/third/sendSms.do");
        excludes.add("/dronecenter/third/register");
        excludes.add("/dronecenter/third/isreg");
        excludes.add("/dronecenter/third/hasPermission");
        excludes.add("/dronecenter/third/getWatermark");
        excludes.add("/dronecenter/third/getConfig");
        excludes.add("/dronecenter/third/getServerUrl");
        excludes.add("/dronecenter/third/getAppNames");
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor()).addPathPatterns(new String[]{"/dronecenter/api/**"}).excludePathPatterns(excludes);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (!registry.hasMappingForPattern("/**")) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(CLASSPATH_RESOURCE_LOCATIONS);
        }
    }
}

