/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.mapper.handler;

import com.geoway.drone.mapper.handler.GeoUtil;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class AbstractGeometryTypeHandler<T extends Geometry>
extends BaseTypeHandler<T> {
    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] bytes = rs.getBytes(columnName);
        return (T)this.fromWkb(bytes);
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] bytes = rs.getBytes(columnIndex);
        return (T)this.fromWkb(bytes);
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] bytes = cs.getBytes(columnIndex);
        return (T)this.fromWkb(bytes);
    }

    private Geometry fromWkb(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteBuffer sridBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).put(bytes, 0, 4);
            sridBuffer.position(0);
            int srid = sridBuffer.getInt();
            byte[] geomBytes = ByteBuffer.allocate(bytes.length - 4).order(ByteOrder.LITTLE_ENDIAN).put(bytes, 4, bytes.length - 4).array();
            if (GeoUtil.getFactory().getSRID() != srid) {
                return new WKBReader(GeoUtil.getFactory(srid)).read(geomBytes);
            }
            return GeoUtil.getWkbReader().read(geomBytes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] wkbFromGeometry(Geometry geometry) {
        int srid = geometry.getSRID();
        byte[] bytes = new WKBWriter(2, 2).write(geometry);
        return ByteBuffer.allocate(bytes.length + 4).order(ByteOrder.LITTLE_ENDIAN).putInt(srid).put(bytes).array();
    }
}

