/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.geoway.drone.model.dto.UserInfo;
import com.geoway.drone.serface.ThirdService;
import com.geoway.drone.service.util.RedisUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class ThirdServiceImpl
implements ThirdService {
    GiLoger loger = GwLoger.getLoger(ThirdServiceImpl.class);
    @Value(value="${dcy.url}")
    String dcyUrl;
    @Resource
    RedisUtils<String> redisUtils;

    public UserInfo login(String username, String password) throws Exception {
        String url = this.dcyUrl + "/security/loginMobile.action";
        HashMap<String, String> parmas = new HashMap<String, String>();
        parmas.put("username", username);
        parmas.put("password", password);
        HttpResponse response = HttpRequest.post((String)url).form(parmas).execute();
        if (response.isOk()) {
            String body = response.body();
            if (StringUtils.isBlank((CharSequence)body)) {
                throw new Exception("\u767b\u5f55\u5931\u8d25");
            }
            JSONObject json = JSONObject.parseObject((String)body);
            if (json.getString("code").equals("200")) {
                UserInfo user = new UserInfo();
                user.setUserid(json.getString("userId"));
                user.setUsername(json.getString("username"));
                user.setRname(json.getString("userRname"));
                user.setToken(json.getString("token"));
                return user;
            }
            this.loger.error("\u98de\u63a7\u767b\u5f55\u5931\u8d25\n" + body + "\n username:" + username + " password:" + password, new Object[0]);
        }
        throw new Exception("\u767b\u5f55\u5931\u8d25");
    }

    public UserInfo verifyToken(String token) throws Exception {
        String userInfo = this.redisUtils.getObject(token);
        if (StringUtils.isBlank((CharSequence)userInfo)) {
            throw new Exception("\u6821\u9a8c\u5931\u8d25:token\u4e0d\u5b58\u5728");
        }
        JSONObject json = JSONObject.parseObject((String)userInfo);
        UserInfo user = new UserInfo();
        user.setUserid(json.getString("userId"));
        user.setUsername(json.getString("username"));
        user.setRname(json.getString("userRname"));
        return user;
    }

    public UserInfo loginByPhone(String phone, String verifyCode) throws Exception {
        String url = this.dcyUrl + "/security/loginMobilePhone.action";
        HashMap<String, String> parmas = new HashMap<String, String>();
        parmas.put("phoneNumber", phone);
        parmas.put("verifyCode", verifyCode);
        HttpResponse response = HttpRequest.post((String)url).form(parmas).execute();
        if (response.isOk()) {
            String body = response.body();
            if (StringUtils.isBlank((CharSequence)body)) {
                throw new Exception("\u767b\u5f55\u5931\u8d25");
            }
            JSONObject json = JSONObject.parseObject((String)body);
            if (json.getString("code").equals("200")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Calendar calendar = Calendar.getInstance();
                calendar.add(10, 24);
                UserInfo user = new UserInfo();
                user.setUserid(json.getString("userId"));
                user.setUsername(json.getString("username"));
                user.setRname(json.getString("userRname"));
                user.setAccess_token(json.getString("token"));
                user.setExpires_in(sdf.format(calendar.getTime()));
                return user;
            }
            this.loger.error("\u98de\u63a7\u767b\u5f55\u5931\u8d25\n" + body + "\n phone:" + phone + " verifyCode:" + verifyCode, new Object[0]);
        }
        throw new Exception("\u767b\u5f55\u5931\u8d25");
    }

    public boolean sendSms(String phone) {
        String url = this.dcyUrl + "/security/sendVertifyCode.action";
        HashMap<String, String> parmas = new HashMap<String, String>();
        parmas.put("phone", phone);
        HttpResponse response = HttpRequest.post((String)url).form(parmas).execute();
        if (response.isOk()) {
            String body = response.body();
            if (StringUtils.isBlank((CharSequence)body)) {
                return false;
            }
            JSONObject json = JSONObject.parseObject((String)body);
            if (!json.getString("code").equals("200")) {
                this.loger.error("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25\n" + body + "\n phone:" + phone, new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }
}

