/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.drone.mapper.AppConfigMapper;
import com.geoway.drone.mapper.DroneAppMapper;
import com.geoway.drone.mapper.DroneDeviceTrackMapper;
import com.geoway.drone.mapper.DroneInfoMapper;
import com.geoway.drone.mapper.DroneLiveChannelMapper;
import com.geoway.drone.mapper.DroneUserMapper;
import com.geoway.drone.model.base.PageResultContent;
import com.geoway.drone.model.dto.DroneDto;
import com.geoway.drone.model.dto.DroneOnOffVo;
import com.geoway.drone.model.dto.DroneReportVo;
import com.geoway.drone.model.entity.AppConfig;
import com.geoway.drone.model.entity.DroneApp;
import com.geoway.drone.model.entity.DroneDeviceTrack;
import com.geoway.drone.model.entity.DroneInfo;
import com.geoway.drone.model.entity.DroneUser;
import com.geoway.drone.model.entity.DroneliveChannel;
import com.geoway.drone.serface.DroneInfoService;
import com.gw.base.gpa.entity.GiEntityAlterable;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DroneInfoServiceImpl
implements DroneInfoService {
    @Value(value="${drone.appkey}")
    private String defaultAppKey;
    @Resource
    AppConfigMapper appConfigMapper;
    @Resource
    DroneInfoMapper droneMapper;
    @Resource
    DroneAppMapper droneAppMapper;
    @Resource
    DroneUserMapper droneUserMapper;
    @Resource
    DroneDeviceTrackMapper droneDeviceTrackMapper;
    @Resource
    DroneLiveChannelMapper droneLiveChannelMapper;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DroneInfoMapper droneInfoMapper;

    @Transactional
    public void setDroneOnline() {
        String sql = "update tb_drone_info set f_online = 0";
        this.jdbcTemplate.execute(sql);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        sql = "update tb_drone_info set f_online = 1 where f_sn in (select distinct(f_sn) as f_sn from tb_drone_devicetrack where f_updatetime > '" + before + "')";
        this.jdbcTemplate.execute(sql);
    }

    public List<DroneDeviceTrack> getDroneLocation(List<String> sns) {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        List tracks = this.droneDeviceTrackMapper.getCurTrackBySns(sns, before);
        return tracks;
    }

    public PageResultContent listByPage(String appkey, String sn, Integer state, Integer online, Integer page, Integer rows) {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            appkey = this.defaultAppKey;
        }
        List list = null;
        int count = 0;
        int offset = (page - 1) * rows;
        if (StringUtils.isNotBlank((CharSequence)appkey)) {
            count = this.droneMapper.countByApp(appkey, sn, state, online);
            if (count > 0) {
                list = this.droneMapper.listPageByApp(appkey, sn, state, online, Integer.valueOf(offset), rows);
            }
        } else {
            count = this.droneMapper.countBy(sn, state, online);
            if (count > 0) {
                list = this.droneMapper.listPage(sn, state, online, Integer.valueOf(offset), rows);
            }
        }
        if (list != null && !list.isEmpty()) {
            Calendar beforeTime = Calendar.getInstance();
            beforeTime.add(12, -3);
            Date beforeD = beforeTime.getTime();
            String before = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
            List sns = list.stream().map(DroneInfo::getSn).collect(Collectors.toList());
            List tracks = this.droneDeviceTrackMapper.getCurTrackBySns(sns, before);
            if (tracks != null && !tracks.isEmpty()) {
                for (DroneDto dto : list) {
                    DroneDeviceTrack track = tracks.stream().filter(t -> t.getSn().equals(dto.getSn())).findFirst().orElse(null);
                    if (track == null) continue;
                    dto.setLon(track.getLon());
                    dto.setLat(track.getLat());
                    dto.setHei(track.getHei());
                    dto.setAzimuth(track.getAzimuth());
                    dto.setTilt(track.getTilt());
                }
            }
        }
        PageResultContent pageResultContent = new PageResultContent();
        pageResultContent.setData(list);
        pageResultContent.setTotal(Long.valueOf(count));
        return pageResultContent;
    }

    public PageResultContent listByPageWithUser(String appkey, String sn, Integer state, Integer online, Integer page, Integer rows) {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            appkey = this.defaultAppKey;
        }
        List list = null;
        int count = 0;
        int offset = (page - 1) * rows;
        count = this.droneMapper.countWithUser(appkey, sn, state, online);
        if (count > 0) {
            list = this.droneMapper.listPageWithUser(appkey, sn, state, online, Integer.valueOf(offset), rows);
        }
        if (list != null && !list.isEmpty()) {
            Calendar beforeTime = Calendar.getInstance();
            beforeTime.add(12, -3);
            Date beforeD = beforeTime.getTime();
            String before = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
            List sns = list.stream().map(DroneInfo::getSn).collect(Collectors.toList());
            List tracks = this.droneDeviceTrackMapper.getCurTrackBySns(sns, before);
            if (tracks != null && !tracks.isEmpty()) {
                for (DroneDto dto : list) {
                    DroneDeviceTrack track = tracks.stream().filter(t -> t.getSn().equals(dto.getSn())).findFirst().orElse(null);
                    if (track == null) continue;
                    dto.setLon(track.getLon());
                    dto.setLat(track.getLat());
                    dto.setHei(track.getHei());
                    dto.setAzimuth(track.getAzimuth());
                    dto.setTilt(track.getTilt());
                }
            }
        }
        PageResultContent pageResultContent = new PageResultContent();
        pageResultContent.setData(list);
        pageResultContent.setTotal(Long.valueOf(count));
        return pageResultContent;
    }

    public int update(DroneDto drone) {
        if (StringUtils.isBlank((CharSequence)drone.getId())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673aid\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getSn())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getModelnum())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u578b\u53f7\u4e3a\u7a7a");
        }
        if (drone.getState() == null) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u72b6\u6001\u672a\u8bbe\u7f6e");
        }
        DroneInfo exist = (DroneInfo)this.droneMapper.selectByPrimaryKey((Object)drone.getId());
        if (exist != null && !exist.getSn().equals(drone.getSn())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u91cd\u590d");
        }
        return this.droneMapper.updateByPrimaryKeySelective((Object)drone);
    }

    public int Allrows() {
        return this.droneMapper.Allrows();
    }

    public DroneDto addOne(DroneDto drone) {
        if (StringUtils.isBlank((CharSequence)drone.getSn())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getModelnum())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u578b\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getAppkey())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u5e94\u7528");
        }
        if (drone.getState() == null) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u72b6\u6001\u672a\u8bbe\u7f6e");
        }
        if (StringUtils.isBlank((CharSequence)drone.getUserid())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u7528\u6237\uff0c\u7528\u6237id\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getUsername())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u7528\u6237\uff0c\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        if (drone.getState() == null) {
            drone.setState(Integer.valueOf(1));
        } else if (!drone.getState().equals(1)) {
            drone.setState(Integer.valueOf(0));
        }
        DroneInfo exist = this.droneMapper.selectBySn(drone.getSn());
        if (exist != null) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u5df2\u5b58\u5728");
        }
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(drone.getAppkey());
        if (appConfig == null) {
            throw new IllegalArgumentException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        drone.setId(UUID.randomUUID().toString());
        drone.setRegtime(new Date());
        this.droneMapper.insert((Object)drone);
        DroneApp droneApp = new DroneApp();
        droneApp.setAppkey(drone.getAppkey());
        droneApp.setSn(drone.getSn());
        droneApp.setId(UUID.randomUUID().toString());
        this.droneAppMapper.insert((Object)droneApp);
        DroneUser droneUser = new DroneUser();
        droneUser.setAppkey(drone.getAppkey());
        droneUser.setSn(drone.getSn());
        droneUser.setUserId(drone.getUserid());
        droneUser.setUserName(drone.getUsername());
        droneUser.setId(UUID.randomUUID().toString());
        droneUser.setRname(drone.getRname());
        droneUser.setPhone(drone.getPhone());
        this.droneUserMapper.insert((Object)droneUser);
        return drone;
    }

    public void setDroneApp(DroneApp drone) {
        if (StringUtils.isBlank((CharSequence)drone.getSn())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getAppkey())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u5e94\u7528");
        }
        DroneInfo exist = this.droneMapper.selectBySn(drone.getSn());
        if (exist == null) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u4e0d\u5b58\u5728");
        }
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(drone.getAppkey());
        if (appConfig == null) {
            throw new IllegalArgumentException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        DroneApp droneApp = this.droneAppMapper.selectByAppDrone(drone.getSn(), drone.getAppkey());
        if (droneApp == null) {
            droneApp = new DroneApp();
            droneApp.setAppkey(drone.getAppkey());
            droneApp.setSn(drone.getSn());
            droneApp.setId(UUID.randomUUID().toString());
            this.droneAppMapper.insert((Object)droneApp);
        }
    }

    public void deleteDroneApp(DroneApp drone) {
        if (StringUtils.isNotBlank((CharSequence)drone.getId())) {
            this.droneAppMapper.deleteByPrimaryKey((Object)drone.getId());
        } else {
            if (StringUtils.isBlank((CharSequence)drone.getSn())) {
                throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)drone.getAppkey())) {
                throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u5e94\u7528");
            }
            this.droneAppMapper.deleteByAppDrone(drone.getSn(), drone.getAppkey());
        }
    }

    public void setDroneUser(DroneUser drone) {
        if (StringUtils.isBlank((CharSequence)drone.getSn())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)drone.getAppkey())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u5e94\u7528");
        }
        if (StringUtils.isBlank((CharSequence)drone.getUserId())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u7528\u6237");
        }
        if (StringUtils.isBlank((CharSequence)drone.getUserName())) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u7528\u6237");
        }
        DroneInfo exist = this.droneMapper.selectBySn(drone.getSn());
        if (exist == null) {
            throw new IllegalArgumentException("\u65e0\u4eba\u673a\u4e0d\u5b58\u5728");
        }
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(drone.getAppkey());
        if (appConfig == null) {
            throw new IllegalArgumentException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        DroneApp droneApp = this.droneAppMapper.selectByAppDrone(drone.getSn(), drone.getAppkey());
        if (droneApp == null) {
            droneApp = new DroneApp();
            droneApp.setAppkey(drone.getAppkey());
            droneApp.setSn(drone.getSn());
            droneApp.setId(UUID.randomUUID().toString());
            this.droneAppMapper.insert((Object)droneApp);
        }
        DroneUser seo = new DroneUser();
        seo.setAppkey(drone.getAppkey());
        seo.setSn(drone.getSn());
        seo.setUserId(drone.getUserId());
        seo.setUserName(drone.getUserName());
        DroneUser droneUser = this.droneUserMapper.selectByAppDroneUser(seo);
        if (droneUser == null) {
            droneUser = seo;
            droneUser.setId(UUID.randomUUID().toString());
            this.droneUserMapper.insert((Object)droneUser);
        }
    }

    public void deleteDroneUser(DroneUser drone) {
        if (StringUtils.isNotBlank((CharSequence)drone.getId())) {
            this.droneUserMapper.deleteByPrimaryKey((Object)drone.getId());
        } else {
            if (StringUtils.isBlank((CharSequence)drone.getSn())) {
                throw new IllegalArgumentException("\u65e0\u4eba\u673a\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)drone.getAppkey())) {
                throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u5e94\u7528");
            }
            if (StringUtils.isBlank((CharSequence)drone.getUserId())) {
                throw new IllegalArgumentException("\u65e0\u4eba\u673a\u672a\u7ed1\u5b9a\u7528\u6237");
            }
            this.droneUserMapper.deleteByAppDroneUser(drone);
        }
    }

    public DroneInfo getDroneBySn(String sn) {
        DroneInfo drone = this.droneMapper.selectBySn(sn);
        return drone;
    }

    public void report(DroneReportVo reportVo) {
        double dist;
        DroneDeviceTrack track;
        if (StringUtils.isBlank((CharSequence)reportVo.getSn())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u7f16\u53f7");
        }
        if (StringUtils.isBlank((CharSequence)reportVo.getUserId())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u7528\u6237id");
        }
        if (reportVo.getLon() == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u6240\u5728\u4f4d\u7f6e\u7ecf\u5ea6");
        }
        if (reportVo.getLat() == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u6240\u5728\u4f4d\u7f6e\u7eac\u5ea6");
        }
        if (reportVo.getHei() == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u9ad8\u5ea6");
        }
        if (reportVo.getAzimuth() == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u65b9\u4f4d\u89d2");
        }
        if (reportVo.getTilt() == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u65e0\u4eba\u673a\u4fef\u4ef0\u89d2");
        }
        boolean insert = true;
        if ((reportVo.getFirstFlag() == null || !reportVo.getFirstFlag().equals(1)) && (track = this.droneDeviceTrackMapper.getPreTrack(reportVo.getSn())) != null && Math.abs(dist = this.distance(track.getLon(), track.getLat(), reportVo.getLon(), reportVo.getLat())) < 20.0) {
            insert = false;
            track.setUpdatetime(new Date());
            track.setAzimuth(reportVo.getAzimuth());
            track.setLon(reportVo.getLon());
            track.setLat(reportVo.getLat());
            track.setHei(reportVo.getHei());
            track.setTilt(reportVo.getTilt());
            this.droneDeviceTrackMapper.gwUpdateByPK((GiEntityAlterable)track);
        }
        if (insert) {
            track = new DroneDeviceTrack();
            BeanUtils.copyProperties((Object)reportVo, (Object)track);
            track.setId(UUID.randomUUID().toString());
            track.setUpdatetime(new Date());
            this.droneDeviceTrackMapper.insert((Object)track);
        }
        this.droneInfoMapper.setDroneOnline(reportVo.getSn());
    }

    public JSONObject getLiveUrl(String sn, String appkey) {
        String replace;
        String httpFullUrl;
        DroneliveChannel droneliveChannel;
        if (StringUtils.isBlank((CharSequence)appkey)) {
            appkey = this.defaultAppKey;
        }
        if ((droneliveChannel = this.droneLiveChannelMapper.selectBySn(sn)) == null) {
            droneliveChannel = new DroneliveChannel();
            droneliveChannel.setId(UUID.randomUUID().toString());
            droneliveChannel.setSn(sn);
            this.droneLiveChannelMapper.insert((Object)droneliveChannel);
        }
        String channelId = droneliveChannel.getChannelId();
        JSONObject result = null;
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(appkey);
        if (appConfig == null) {
            throw new IllegalArgumentException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)appConfig.getYxkey()) || StringUtils.isBlank((CharSequence)appConfig.getYxsecret())) {
            throw new IllegalArgumentException("\u5e94\u7528:" + appConfig.getName() + "[" + appkey + "]\u672a\u914d\u7f6e\u4e91\u4fe1\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)channelId)) {
            result = this.createChanel(sn, appConfig.getYxkey(), appConfig.getYxsecret());
            if (result == null) {
                throw new IllegalArgumentException("\u521b\u5efa\u4e91\u4fe1\u76f4\u64ad\u9891\u9053\u5931\u8d25");
            }
            channelId = result.getString("cid");
            droneliveChannel.setChannelId(channelId);
            this.droneLiveChannelMapper.updateByPrimaryKeySelective((Object)droneliveChannel);
        } else {
            result = this.refreshUrl(channelId, appConfig.getYxkey(), appConfig.getYxsecret());
        }
        if (result.containsKey((Object)"httpPullUrl") && StringUtils.isNotBlank((CharSequence)result.getString("httpPullUrl")) && !result.getString("httpPullUrl").contains("https")) {
            httpFullUrl = result.getString("httpPullUrl");
            replace = httpFullUrl.replace("http", "https");
            result.put("httpPullUrl", (Object)replace);
        }
        if (result.containsKey((Object)"hlsPullUrl") && StringUtils.isNotBlank((CharSequence)result.getString("hlsPullUrl")) && !result.getString("hlsPullUrl").contains("https")) {
            httpFullUrl = result.getString("hlsPullUrl");
            replace = httpFullUrl.replace("http", "https");
            result.put("hlsPullUrl", (Object)replace);
        }
        result.put("status", (Object)0);
        JSONArray resultJsonArray = this.queryStatus(appConfig.getYxkey(), appConfig.getYxsecret());
        for (Object o : resultJsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            if (!jsonObject.get((Object)"name").equals(droneliveChannel.getSn())) continue;
            result.put("status", jsonObject.get((Object)"status"));
            droneliveChannel.setStatus(jsonObject.getInteger("status"));
            this.droneLiveChannelMapper.updateByPrimaryKeySelective((Object)droneliveChannel);
            break;
        }
        if (0 == result.getInteger("status")) {
            droneliveChannel.setStatus(Integer.valueOf(0));
            this.droneLiveChannelMapper.updateByPrimaryKeySelective((Object)droneliveChannel);
        }
        return result;
    }

    public List<DroneDto> getNearDrone(String appkey, Double lon, Double lat, Double distance) throws ParseException {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            appkey = this.defaultAppKey;
        }
        if (distance == null) {
            distance = 5000.0;
        }
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -3);
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql = String.format("with t1 as (select f_sn,f_userid,max(f_updatetime) as f_updatetime from tb_drone_devicetrack td where f_updatetime > '%s' group by f_sn,f_userid),\nt3 as (select t2.f_sn,t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_drone_devicetrack t2,t1 where t2.f_sn  = t1.f_sn and t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\nt4 as (select * from t3 where f_distance <%s order by f_distance) \nselect t4.*,t7.f_company,t7.f_modelnum,t7.f_device_name,t7.f_device_com,t7.f_regtime from t4 left join tb_drone_info t7 on t4.f_sn = t7.f_sn", before5, lon, lat, distance);
        List maps = this.jdbcTemplate.queryForList(sql);
        if (maps == null || maps.isEmpty()) {
            return null;
        }
        ArrayList<DroneDto> droneDtos = new ArrayList<DroneDto>();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map map : maps) {
            String userId = map.get("f_userid") != null ? map.get("f_userid").toString() : "";
            String username = map.get("f_username") != null ? map.get("f_username").toString() : "";
            String rname = map.get("f_rname") != null ? map.get("f_rname").toString() : "";
            String phone = map.get("f_phone") != null ? map.get("f_phone").toString() : "";
            String sn = map.get("f_sn") != null ? map.get("f_sn").toString() : "";
            String name = map.get("f_modelnum") != null ? map.get("f_modelnum").toString() : "";
            String company = map.get("f_company") != null ? map.get("f_company").toString() : "";
            String deviceName = map.get("f_device_name") != null ? map.get("f_device_name").toString() : "";
            String deviceCom = map.get("f_device_com") != null ? map.get("f_device_com").toString() : "";
            String regTime = map.get("f_regtime") != null ? map.get("f_regtime").toString() : "";
            DroneDto drone = new DroneDto();
            drone.setUserid(userId);
            drone.setUsername(username);
            drone.setRname(rname);
            drone.setPhone(phone);
            drone.setDistance(Double.valueOf(Double.parseDouble(map.get("f_distance").toString())));
            drone.setLon(Double.valueOf(Double.parseDouble(map.get("f_lon").toString())));
            drone.setLat(Double.valueOf(Double.parseDouble(map.get("f_lat").toString())));
            drone.setSn(sn);
            drone.setState(Integer.valueOf(1));
            drone.setOnline(Integer.valueOf(1));
            drone.setAppkey(appkey);
            drone.setDeviceName(deviceName);
            drone.setDeviceCom(deviceCom);
            drone.setCompany(company);
            drone.setModelnum(name);
            drone.setRegtime(df.parse(regTime));
            droneDtos.add(drone);
        }
        return droneDtos;
    }

    public DroneOnOffVo getDroneOnOff(String appkey) {
        if (StringUtils.isBlank((CharSequence)appkey)) {
            appkey = this.defaultAppKey;
        }
        Integer onLineCount = this.droneMapper.countWithUser(appkey, null, Integer.valueOf(1), Integer.valueOf(1));
        Integer totalCount = this.droneMapper.countWithUser(appkey, null, Integer.valueOf(1), null);
        Integer offLineCount = totalCount - onLineCount;
        Double onrate = 0.0;
        Double offrate = 0.0;
        if (totalCount > 0) {
            onrate = (double)onLineCount.intValue() * 100.0 / (double)totalCount.intValue();
            offrate = (double)offLineCount.intValue() * 100.0 / (double)totalCount.intValue();
        }
        DecimalFormat df = new DecimalFormat("#.00");
        onrate = Double.parseDouble(df.format(onrate));
        offrate = Double.parseDouble(df.format(offrate));
        DroneOnOffVo result = new DroneOnOffVo();
        result.setOnLineCount(onLineCount);
        result.setOffLineCount(offLineCount);
        result.setTotalCount(totalCount);
        result.setOnLineRate(onrate);
        result.setOffLineRate(offrate);
        return result;
    }

    private double distance(double lon1, double lat1, double lon2, double lat2) {
        double radLat1 = lat1 * Math.PI / 180.0;
        double radLat2 = lat2 * Math.PI / 180.0;
        double a = radLat1 - radLat2;
        double b = (lon1 - lon2) * Math.PI / 180.0;
        double earthRadius = 6378137.0;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= earthRadius;
        s = Math.round(s * 10000.0) / 10000L;
        return s;
    }

    private JSONObject createChanel(String sn, String yxkey, String yxsecret) {
        JSONObject param = new JSONObject();
        param.put("name", (Object)sn);
        param.put("type", (Object)0);
        try {
            JSONObject result = this.apiCaller("https://vcloud.163.com/app/channel/create", param, yxkey, yxsecret);
            return Optional.ofNullable(result).map(e -> e.getJSONObject("ret")).get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public JSONObject refreshUrl(String cid, String yxkey, String yxsecret) {
        JSONObject param = new JSONObject();
        param.put("cid", (Object)cid);
        try {
            JSONObject result = this.apiCaller("https://vcloud.163.com/app/address", param, yxkey, yxsecret);
            return Optional.ofNullable(result).map(e -> e.getJSONObject("ret")).get();
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return new JSONObject();
        }
    }

    public JSONArray queryStatus(String yxkey, String yxsecret) {
        JSONObject param = new JSONObject();
        param.put("status", (Object)1);
        param.put("records", (Object)20);
        try {
            JSONObject result = this.apiCaller("https://vcloud.163.com/app/channellist", param, yxkey, yxsecret);
            return Optional.ofNullable(result).map(e -> e.getJSONObject("ret")).map(e -> e.getJSONArray("list")).get();
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return new JSONArray();
        }
    }

    private JSONObject apiCaller(String url, JSONObject param, String yxkey, String yxsecret) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        String nonce = UUID.randomUUID().toString();
        String curTime = String.valueOf(new Date().getTime() / 1000L);
        String checkSum = CheckSumBuilder.getCheckSum(yxsecret, nonce, curTime);
        headers.put("AppKey", yxkey);
        headers.put("Nonce", nonce);
        headers.put("CurTime", curTime);
        headers.put("CheckSum", checkSum);
        headers.put("Content-Type", "application/json;charset=utf-8");
        String body = param == null ? "" : param.toJSONString();
        HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).addHeaders(headers)).body(body).execute();
        if (response != null && response.isOk()) {
            return JSONObject.parseObject((String)response.body());
        }
        throw new Exception("Https Response Failed :" + response.body());
    }

    public static class CheckSumBuilder {
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

        public static String getCheckSum(String appSecret, String nonce, String curTime) {
            return CheckSumBuilder.encode("sha1", appSecret + nonce + curTime);
        }

        private static String encode(String algorithm, String value) {
            if (value == null) {
                return null;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
                messageDigest.update(value.getBytes());
                return CheckSumBuilder.getFormattedText(messageDigest.digest());
            }
            catch (Exception var3) {
                throw new RuntimeException(var3);
            }
        }

        private static String getFormattedText(byte[] bytes) {
            int len = bytes.length;
            StringBuilder buf = new StringBuilder(len * 2);
            for (int j = 0; j < len; ++j) {
                buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
                buf.append(HEX_DIGITS[bytes[j] & 0xF]);
            }
            return buf.toString();
        }
    }
}

