/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service;

import com.geoway.drone.mapper.AppConfigMapper;
import com.geoway.drone.model.base.PageResultContent;
import com.geoway.drone.model.entity.AppConfig;
import com.geoway.drone.serface.AppConfigService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppConfigServiceImlp
implements AppConfigService {
    @Autowired
    private AppConfigMapper appConfigMapper;

    public PageResultContent listByPage(String appkey, String name, Integer page, Integer everyPageNum) {
        PageResultContent resultContent = new PageResultContent();
        int count = this.appConfigMapper.countForPage(appkey, name);
        if (count > 0) {
            List configs = this.appConfigMapper.listByPage(appkey, name, Integer.valueOf((page - 1) * everyPageNum), everyPageNum);
            resultContent.setData(configs);
        }
        resultContent.setTotal(Long.valueOf(count));
        return resultContent;
    }

    public void insert(AppConfig appConfig) {
        String str = appConfig.getUisurl();
        String regex = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
        AppConfig app = this.appConfigMapper.appkeyisExist(appConfig.getAppkey());
        if (app != null && !app.getId().equals(appConfig.getId())) {
            throw new IllegalArgumentException("\u5e94\u7528\u5df2\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)appConfig.getYxkey()) || StringUtils.isBlank((CharSequence)appConfig.getYxsecret())) {
            throw new IllegalArgumentException("\u672a\u914d\u7f6e\u4e91\u4fe1\u4fe1\u606f");
        }
        if (!Pattern.matches(regex, str)) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786eurl\u5730\u5740");
        }
        Date currentTime = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String string = simpleDateFormat.format(currentTime);
        appConfig.setItime((Date)Timestamp.valueOf(string));
        appConfig.setId(UUID.randomUUID().toString().replace("-", ""));
        this.appConfigMapper.insert((Object)appConfig);
    }

    public void update(AppConfig appConfig) {
        AppConfig app = this.appConfigMapper.appkeyisExist(appConfig.getAppkey());
        if (app != null && !app.getId().equals(appConfig.getId())) {
            throw new IllegalArgumentException("Appkey\u4e0d\u53ef\u91cd\u590d");
        }
        String str = appConfig.getUisurl();
        if (StringUtils.isBlank((CharSequence)str)) {
            this.appConfigMapper.updateByPrimaryKeySelective((Object)appConfig);
        } else {
            String regex = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
            if (Pattern.matches(regex, str)) {
                this.appConfigMapper.updateByPrimaryKeySelective((Object)appConfig);
            } else {
                throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u6b63\u786eurl\u5730\u5740");
            }
        }
    }
}

