/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service;

import com.geoway.drone.mapper.AppServerMapper;
import com.geoway.drone.model.base.PageResultContent;
import com.geoway.drone.model.entity.AppServer;
import com.geoway.drone.serface.AppServerService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AppServerServiceImpl
implements AppServerService {
    GiLoger loger = GwLoger.getLoger(AppServerService.class);
    @Autowired
    AppServerMapper appServerMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public void update(AppServer appServer) {
        if (StringUtils.isBlank((CharSequence)appServer.getId())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6eid");
        }
        if (StringUtils.isBlank((CharSequence)appServer.getAppkey())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5e94\u7528appkey");
        }
        AppServer appServerObj = this.appServerMapper.getByAppkey(appServer.getAppkey());
        if (appServerObj != null && !appServerObj.getId().equals(appServer.getId())) {
            throw new IllegalArgumentException("\u5e94\u7528appkey\u5df2\u5b58\u5728");
        }
        this.appServerMapper.updateByPrimaryKeySelective((Object)appServer);
    }

    public void insert(AppServer appServer) {
        if (StringUtils.isBlank((CharSequence)appServer.getAppkey())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5e94\u7528appkey");
        }
        if (StringUtils.isBlank((CharSequence)appServer.getUploadurl())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5e94\u7528\u4e0a\u4f20\u9644\u4ef6\u5730\u5740");
        }
        if (StringUtils.isBlank((CharSequence)appServer.getServerurl())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5e94\u7528\u670d\u52a1\u5730\u5740");
        }
        if (StringUtils.isBlank((CharSequence)appServer.getConfig())) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u5e94\u7528\u914d\u7f6e");
        }
        AppServer appServerObj = this.appServerMapper.getByAppkey(appServer.getAppkey());
        if (appServerObj != null && !appServerObj.getId().equals(appServer.getId())) {
            throw new IllegalArgumentException("\u5e94\u7528appkey\u5df2\u5b58\u5728");
        }
        Date currentTime = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String string = simpleDateFormat.format(currentTime);
        appServer.setId(UUID.randomUUID().toString());
        appServer.setTime((Date)Timestamp.valueOf(string));
        this.appServerMapper.insert((Object)appServer);
    }

    public PageResultContent listByPage(String appkey, Integer page, Integer everyPageNum) {
        PageResultContent resultContent = new PageResultContent();
        int count = this.appServerMapper.countForPage(appkey);
        if (count > 0) {
            List configs = this.appServerMapper.listByPage(appkey, Integer.valueOf((page - 1) * everyPageNum), everyPageNum);
            resultContent.setData(configs);
        }
        resultContent.setTotal(Long.valueOf(count));
        return resultContent;
    }

    public String getPhotoBase64(String appkey) {
        InputStream is = null;
        ByteArrayOutputStream byteStream = null;
        try {
            Object[] arr = new Object[]{appkey};
            ResultSetExtractor<InputStream> byteaExtractor = new ResultSetExtractor<InputStream>(){

                public InputStream extractData(ResultSet rs) throws SQLException, DataAccessException {
                    if (rs.next()) {
                        return rs.getBinaryStream("f_watermark");
                    }
                    return null;
                }
            };
            is = (InputStream)this.jdbcTemplate.query("select f_watermark from tb_drone_appserver where f_appkey = ?", (ResultSetExtractor)byteaExtractor, arr);
            byteStream = new ByteArrayOutputStream();
            byte[] temp = new byte[4096];
            int bytesRead = 0;
            int off = 0;
            while ((bytesRead = is.read(temp)) != -1) {
                byteStream.write(temp, 0, bytesRead);
                off += bytesRead;
            }
            byte[] bytes = byteStream.toByteArray();
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
        catch (Exception ex) {
            this.loger.error("\u83b7\u53d6\u5e94\u7528\u6c34\u5370\u7167\u7247\u5931\u8d25", new Object[]{ex});
            throw new IllegalArgumentException("\u83b7\u53d6\u5e94\u7528\u6c34\u5370\u7167\u7247\u5931\u8d25");
        }
        finally {
            if (byteStream != null) {
                try {
                    byteStream.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Object getPhoto(String appkey) {
        return this.appServerMapper.GetPhoto(appkey);
    }

    public void setPhoto(String appkey, MultipartFile file) {
        AppServer server = this.appServerMapper.getByAppkey(appkey);
        if (server == null) {
            throw new IllegalArgumentException("\u5e94\u7528\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        InputStream is = null;
        ByteArrayOutputStream byteStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            is = file.getInputStream();
            byte[] temp = new byte[4096];
            int bytesRead = 0;
            int off = 0;
            while ((bytesRead = is.read(temp)) != -1) {
                byteStream.write(temp, 0, bytesRead);
                off += bytesRead;
            }
            byte[] bytes = byteStream.toByteArray();
            Object[] arr = new Object[]{bytes, appkey};
            int n = this.jdbcTemplate.update("update tb_drone_appserver set f_watermark = ? where f_appkey = ?", arr);
        }
        catch (Exception ex) {
            this.loger.error("\u8bbe\u7f6e\u5e94\u7528\u6c34\u5370\u7167\u7247\u5931\u8d25", new Object[]{ex});
            throw new IllegalArgumentException("\u8bbe\u7f6e\u5e94\u7528\u6c34\u5370\u7167\u7247\u5931\u8d25");
        }
        finally {
            if (byteStream != null) {
                try {
                    byteStream.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public AppServer getServer(String appkey) {
        return this.appServerMapper.getByAppkey(appkey);
    }

    public List<Map> selectNameByAppkeys(List<String> appkeys) {
        return this.appServerMapper.selectNameByAppkeys(appkeys);
    }
}

