/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service.util;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisUtils<T> {
    @Resource
    private RedisTemplate<String, T> redisTemplate;

    public T getObject(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return (T)this.redisTemplate.opsForValue().get((Object)key);
    }

    public boolean setObject(String key, T value) {
        return this.setObject(key, value, 0L);
    }

    public boolean setObject(String key, T value, long time) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return false;
        }
        if (time == 0L) {
            this.redisTemplate.opsForValue().set((Object)key, value);
        } else {
            this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
        }
        return true;
    }

    public boolean addObjInvalidTime(String key, long time) {
        if (StringUtils.isEmpty((CharSequence)key) && this.redisTemplate.getExpire((Object)key) <= 0L) {
            return false;
        }
        return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    public boolean removeObj(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        this.redisTemplate.delete((Object)key);
        return true;
    }
}

