/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.drone.service;

import com.alibaba.fastjson.JSONObject;
import com.geoway.drone.mapper.AppConfigMapper;
import com.geoway.drone.model.entity.AppConfig;
import com.geoway.drone.serface.UisService;
import com.geoway.drone.service.util.AESECB;
import com.geoway.drone.service.util.HttpConnectionUtil;
import com.geoway.drone.service.util.Md5Utils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UisServicelmpl
implements UisService {
    @Autowired
    AppConfigMapper appConfigMapper;

    public JSONObject loginUIS(String username, String password, String appkey) throws Exception {
        String appsecret;
        String postStr;
        String result;
        JSONObject jsonObject;
        String status;
        JSONObject resultJson = new JSONObject();
        if (StringUtils.isBlank((CharSequence)appkey)) {
            throw new Exception("appkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(appkey);
        String url = appConfig.getUisurl();
        if (StringUtils.isNotBlank((CharSequence)url) && url.indexOf("accesstoken") < 0) {
            url = url + "/manager/Oauth/accesstoken";
        }
        if ("OK".equalsIgnoreCase(status = (jsonObject = JSONObject.parseObject((String)(result = HttpConnectionUtil.AccessUrl(url, postStr = String.format("appkey=%s&appsecret=%s&grant_type=password&username=%s&password=%s", appkey, appsecret = appConfig.getAppsecret(), username, password))))).getString("status"))) {
            String token = jsonObject.getJSONObject("data").getString("access_token");
            resultJson.put("token", (Object)token);
            resultJson.put("userid", (Object)jsonObject.getJSONObject("data").getString("userid"));
            if (jsonObject.getJSONObject("data").containsKey((Object)"rname")) {
                resultJson.put("rname", (Object)jsonObject.getJSONObject("data").getString("rname"));
            }
        } else {
            String errorMessage = jsonObject.getString("errorMessage");
            throw new Exception("\u767b\u5f55\u5931\u8d25:" + errorMessage);
        }
        return resultJson;
    }

    public JSONObject verifyToken(String appkey, String token) throws Exception {
        String result;
        JSONObject jsonObject;
        String status;
        JSONObject resultJson = new JSONObject();
        if (StringUtils.isBlank((CharSequence)appkey)) {
            throw new Exception("appkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppConfig appConfig = this.appConfigMapper.getAppConfigByAppkey(appkey);
        String url = appConfig.getUisurl();
        if (StringUtils.isNotBlank((CharSequence)url) && url.indexOf("verifyToken") < 0) {
            url = url + "/manager/Oauth/verifyToken/" + token;
        }
        if (!"OK".equalsIgnoreCase(status = (jsonObject = JSONObject.parseObject((String)(result = HttpConnectionUtil.AccessUrl(url, "")))).getString("status"))) {
            String errorMessage = jsonObject.getString("errorMessage");
            throw new Exception("\u6821\u9a8c\u5931\u8d25:" + errorMessage);
        }
        resultJson.put("userid", (Object)jsonObject.getJSONObject("data").getString("userid"));
        resultJson.put("username", (Object)jsonObject.getJSONObject("data").getString("username"));
        return resultJson;
    }

    private JSONObject postJson(String uisHost, String appkey, String appsecret, String url, Map<String, Object> params, boolean addSign) throws Exception {
        RestTemplate restTemplate = this.getRestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((Object)JSONObject.toJSONString(params), (MultiValueMap)headers);
        url = addSign ? this.addSign(uisHost, appkey, appsecret, url) : uisHost + url;
        ResponseEntity res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
        return (JSONObject)res.getBody();
    }

    private RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        List converters = restTemplate.getMessageConverters();
        if (converters != null && !converters.isEmpty()) {
            for (int i = 0; i < converters.size(); ++i) {
                if (!(converters.get(i) instanceof StringHttpMessageConverter)) continue;
                StringHttpMessageConverter converter = (StringHttpMessageConverter)converters.get(i);
                converter.setDefaultCharset(Charset.forName("UTF-8"));
                break;
            }
        }
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }

    private String addSign(String uisHost, String appkey, String appsecret, String url) throws Exception {
        if (!url.contains("?")) {
            url = url + "?";
        }
        url = uisHost + url + "appkey=" + appkey + "&timestamp=" + System.currentTimeMillis();
        String cKey = Md5Utils.getMD5Str16(appsecret, "utf-8");
        String sign = AESECB.encrypt(cKey, url);
        url = url + "&sign=" + sign;
        return url;
    }
}

