/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.input;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.dto.meta.MetaFieldMappingCheckDTO;
import com.geoway.imagedb.input.dto.meta.MetaPluginAddDTO;
import com.geoway.imagedb.input.dto.meta.MetaPluginCopyDTO;
import com.geoway.imagedb.input.dto.meta.MetaPluginEditDTO;
import com.geoway.imagedb.input.dto.meta.PluginDTO;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.service.ImageMetaDataPluginService;
import com.geoway.imagedb.input.service.ImageMetaPluginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/import/metadata/plugin"})
@Api(tags={"04.01-\u5143\u6570\u636e\u63d2\u4ef6"})
public class ImageMetaDataPluginController {
    @Resource
    private ImageMetaDataPluginService imageMetaDataPluginService;
    @Resource
    private ImageMetaPluginService imageMetaPluginService;

    @ApiOperation(value="01.01-\u5143\u6570\u636e\u63d2\u4ef6\u5217\u8868(\u914d\u7f6e\u6587\u4ef6)")
    @GetMapping(value={"/list"})
    public Response<List<MetaPluginInfo>> list() {
        return Response.ok((Object)this.imageMetaDataPluginService.list());
    }

    @ApiOperation(value="01.02-\u5143\u6570\u636e\u63d2\u4ef6\u5217\u8868")
    @GetMapping(value={"/config/list"})
    public Response<List<ImageMetaPluginDTO>> getList(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.imageMetaPluginService.getList(keyword));
    }

    @ApiOperation(value="02-\u5143\u6570\u636e\u63d2\u4ef6\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<ImageMetaPluginDTO> getDetail(@RequestParam String id) {
        return Response.ok((Object)this.imageMetaPluginService.getDetail(id));
    }

    @ApiOperation(value="03-\u6dfb\u52a0\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/add"})
    public Response<String> addMetaPlugin(@RequestBody MetaPluginAddDTO addDTO) {
        return Response.ok((Object)this.imageMetaPluginService.addMetaPlugin(addDTO.getName(), addDTO.getDesc()));
    }

    @ApiOperation(value="04-\u4fee\u6539\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/update"})
    public Response<String> updateMetaPlugin(@RequestBody MetaPluginEditDTO editDTO) {
        return Response.ok((Object)this.imageMetaPluginService.updateMetaPlugin(editDTO.getId(), editDTO.getName(), editDTO.getDesc()));
    }

    @ApiOperation(value="05-\u4fdd\u5b58\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/save"})
    public Response<String> saveMetaPlugin(@RequestBody ImageMetaPluginDTO metaPlugin) {
        return Response.ok((Object)this.imageMetaPluginService.saveMetaPlugin(metaPlugin));
    }

    @ApiOperation(value="06-\u5220\u9664\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/delete"})
    public Response<Integer> deleteMetaPlugin(@RequestParam String id) {
        return Response.ok((Object)this.imageMetaPluginService.deleteMetaPlugin(id));
    }

    @ApiOperation(value="07-\u590d\u5236\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/copy"})
    public Response<String> copyMetaPlugin(@RequestBody MetaPluginCopyDTO copyDTO) {
        return Response.ok((Object)this.imageMetaPluginService.copyMetaPlugin(copyDTO.getSourceId(), copyDTO.getTargetId()));
    }

    @ApiOperation(value="08-\u5bfc\u5165\u5143\u6570\u636e\u63d2\u4ef6")
    @PostMapping(value={"/import"})
    public Response<String> importMetaPlugin(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.imageMetaPluginService.importMetaPlugin(file));
    }

    @ApiOperation(value="09-\u5bfc\u51fa\u5143\u6570\u636e\u63d2\u4ef6")
    @GetMapping(value={"/export"})
    public void exportMetaPlugin(@RequestParam String id) {
        this.imageMetaPluginService.exportMetaPlugin(id);
    }

    @ApiOperation(value="10-\u6821\u9a8c\u5143\u6570\u636e\u89e3\u6790")
    @GetMapping(value={"/check"})
    public Response<List<MetaFieldMappingCheckDTO>> checkMetaPlugin(@RequestParam String id, @RequestParam String metaFilePath) {
        return Response.ok((Object)this.imageMetaPluginService.checkMetaPlugin(id, metaFilePath));
    }

    @ApiOperation(value="11-\u5bfc\u5165\u5143\u6570\u636e\u63d2\u4ef6\u5b57\u6bb5\u6620\u5c04")
    @PostMapping(value={"/import/mapping"})
    public Response<ImageMetaPluginDTO> importMetaPluginMapping(@RequestParam String id, @RequestPart MultipartFile mappingFile) {
        return Response.ok((Object)this.imageMetaPluginService.importMetaPluginMapping(id, mappingFile));
    }

    @ApiOperation(value="12-\u63d2\u4ef6\u5217\u8868")
    @GetMapping(value={"/plugin/list"})
    public Response<List<PluginDTO>> getPluginList() {
        return Response.ok((Object)this.imageMetaPluginService.getPluginList());
    }
}

