/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.requirement;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementApprovalDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementCreateDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementDataDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementExportDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementFilterDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementVO;
import com.geoway.imagedb.apply.service.ImageRequirementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/requirement"})
@Api(tags={"05.03-\u5f71\u50cf\u6570\u636e\u9700\u6c42"})
public class ImageRequirementController {
    @Resource
    private ImageRequirementService imageRequirementService;

    @ApiOperation(value="01-\u63d0\u4ea4\u5f71\u50cf\u6570\u636e\u9700\u6c42")
    @PostMapping(value={"/create"})
    public Response<String> createImageRequirement(@RequestBody ImageRequirementCreateDTO createDTO) {
        return Response.ok((Object)this.imageRequirementService.createImageRequirement(createDTO));
    }

    @ApiOperation(value="02.01-\u67e5\u8be2\u5f71\u50cf\u6570\u636e\u9700\u6c42\u5217\u8868")
    @GetMapping(value={"/list"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", required=false, value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", required=false, value="\u8ba2\u5355\u72b6\u6001", paramType="query", allowableValues="com.geoway.imagedb.apply.constant.ImageRequirementStatusEnum"), @ApiImplicitParam(name="key", required=false, value="\u5173\u952e\u5b57", paramType="query"), @ApiImplicitParam(name="startTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0b\u9650", paramType="query"), @ApiImplicitParam(name="endTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0a\u9650", paramType="query")})
    public Response<PageList<ImageRequirementVO>> listImageRequirement(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) Integer status, @RequestParam(required=false) String key, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date startTime, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date endTime) {
        ImageRequirementFilterDTO dto = new ImageRequirementFilterDTO();
        dto.setKey(key);
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setStatus(status != null ? String.valueOf(status) : null);
        dto.setPageIndex(pageIndex);
        dto.setRows(rows);
        return Response.ok((Object)this.imageRequirementService.listImageRequirement(dto));
    }

    @ApiOperation(value="02.02-\u67e5\u8be2\u6211\u7684\u5f71\u50cf\u6570\u636e\u9700\u6c42\u5217\u8868")
    @GetMapping(value={"/my/list"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", required=false, value="\u5206\u9875\u7d22\u5f15", paramType="query", defaultValue="0"), @ApiImplicitParam(name="rows", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", defaultValue="10"), @ApiImplicitParam(name="status", required=false, value="\u8ba2\u5355\u72b6\u6001", paramType="query", allowableValues="com.geoway.imagedb.apply.constant.ImageRequirementStatusEnum"), @ApiImplicitParam(name="key", required=false, value="\u5173\u952e\u5b57", paramType="query"), @ApiImplicitParam(name="startTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0b\u9650", paramType="query"), @ApiImplicitParam(name="endTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0a\u9650", paramType="query")})
    public Response<PageList<ImageRequirementVO>> myListImageRequirement(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) Integer status, @RequestParam(required=false) String key, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date startTime, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date endTime) {
        ImageRequirementFilterDTO dto = new ImageRequirementFilterDTO();
        dto.setKey(key);
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        dto.setStatus(status != null ? String.valueOf(status) : null);
        dto.setPageIndex(pageIndex);
        dto.setRows(rows);
        return Response.ok((Object)this.imageRequirementService.myListImageRequirement(dto));
    }

    @ApiOperation(value="03-\u67e5\u770b\u5f71\u50cf\u6570\u636e\u9700\u6c42\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @ApiImplicitParam(name="apply_id", required=true, value="\u6570\u636e\u8ba2\u5355id", paramType="query")
    public Response<ImageRequirementVO> getDetail(@RequestParam String apply_id) {
        return Response.ok((Object)this.imageRequirementService.getDetail(apply_id));
    }

    @ApiOperation(value="04-\u64a4\u9500/\u5220\u9664\u5f71\u50cf\u6570\u636e\u9700\u6c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="apply_ids", required=true, value="\u6570\u636e\u8ba2\u5355id\uff0c\u4ee5\u9017\u53f7\u5206\u9694", paramType="query")})
    @PostMapping(value={"/repeal"})
    public Response repealImageRequirement(String apply_ids) {
        this.imageRequirementService.repealImageRequirement(apply_ids);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5ba1\u6279/\u518d\u6b21\u5ba1\u6279\u5f71\u50cf\u6570\u636e\u9700\u6c42")
    @PostMapping(value={"/approve"})
    public Response approveImageRequirement(@RequestBody ImageRequirementApprovalDTO dto) {
        this.imageRequirementService.approveImageRequirement(dto);
        return Response.ok();
    }

    @ApiOperation(value="06-\u4e0b\u8f7d\u5f71\u50cf\u6570\u636e\u9700\u6c42\u6a21\u677f")
    @GetMapping(value={"/download/template"})
    public void downloadTemplateExcel() {
        this.imageRequirementService.downloadTemplateExcel();
    }

    @ApiOperation(value="07-\u5bfc\u51fa\u5f71\u50cf\u6570\u636e\u9700\u6c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", required=false, value="\u8ba2\u5355\u72b6\u6001", paramType="query", allowableValues="com.geoway.imagedb.apply.constant.ImageRequirementStatusEnum"), @ApiImplicitParam(name="key", required=false, value="\u5173\u952e\u5b57", paramType="query"), @ApiImplicitParam(name="startTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0b\u9650", paramType="query"), @ApiImplicitParam(name="endTime", required=false, value="\u7533\u8bf7\u65f6\u95f4\u4e0a\u9650", paramType="query")})
    @GetMapping(value={"/export"})
    public void exportRequirementData(@RequestParam(required=false) Integer status, @RequestParam(required=false) String key, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date startTime, @RequestParam(required=false) @DateTimeFormat(pattern="yyyy-MM-dd") Date endTime) {
        ImageRequirementExportDTO dto = new ImageRequirementExportDTO();
        dto.setStatus(status != null ? String.valueOf(status) : null);
        dto.setKey(key);
        dto.setStartTime(startTime);
        dto.setEndTime(endTime);
        this.imageRequirementService.exportRequirementData(dto);
    }

    @ApiOperation(value="08-\u4eceExcel\u8bfb\u53d6\u5f71\u50cf\u6570\u636e\u9700\u6c42")
    @PostMapping(value={"/read/excel"})
    public Response<List<ImageRequirementDataDTO>> readRequirementDataFromExcel(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.imageRequirementService.readRequirementDataFromExcel(file));
    }
}

