--创建字段管理表并添加系统字段
CREATE TABLE tbimg_field
(
    f_id            varchar(32)  NOT NULL PRIMARY KEY,
    f_name          varchar(100) NOT NULL,
    f_aliasname     varchar(500) NULL,
    f_desc          varchar(2000) NULL,
    f_fieldtype     int4 NULL,
    f_length        int4 NULL,
    f_defaultvalue  varchar(2000) NULL,
    f_nullable      int4 NULL,
    f_domainid      varchar(32) NULL,
    f_order         int4 NULL,
    f_pid           varchar(32) NULL,
    f_isgroup       int4 NULL,
    f_issysfield int4 NULL DEFAULT 0,
    f_queryuitype   int4 NULL,
    f_queryuiparams varchar(2000) NULL
);
COMMENT ON TABLE tbimg_field IS '字段管理表';

COMMENT ON COLUMN tbimg_field.f_id IS '标识';
COMMENT ON COLUMN tbimg_field.f_name IS '名称';
COMMENT ON COLUMN tbimg_field.f_aliasname IS '别名';
COMMENT ON COLUMN tbimg_field.f_desc IS '备注';
COMMENT ON COLUMN tbimg_field.f_fieldtype IS '字段类型';
COMMENT ON COLUMN tbimg_field.f_length IS '字段长度';
COMMENT ON COLUMN tbimg_field.f_defaultvalue IS '默认值';
COMMENT ON COLUMN tbimg_field.f_nullable IS '是否允许为空';
COMMENT ON COLUMN tbimg_field.f_domainid IS '值域标识';
COMMENT ON COLUMN tbimg_field.f_order IS '顺序';
COMMENT ON COLUMN tbimg_field.f_pid IS '父节点标识';
COMMENT ON COLUMN tbimg_field.f_isgroup IS '是否为分组';
COMMENT ON COLUMN tbimg_field.f_issysfield IS '是否为系统字段';
COMMENT ON COLUMN tbimg_field.f_queryuitype IS '查询界面类型';
COMMENT ON COLUMN tbimg_field.f_queryuiparams IS 'UI参数，根据UI类型不同，此字段值也不同';

INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10000', '系统字段', '系统字段', NULL, NULL, NULL, NULL, NULL, 1, '-1', 1, NULL, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10001', 'F_SERVERID', '存储节点ID', 10, 200, NULL, NULL, NULL, 1, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10002', 'F_DATAID', '数据ID', 8, 1, NULL, NULL, NULL, 2, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10003', 'F_DATANAME', '数据名称', 10, 255, NULL, NULL, NULL, 3, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10004', 'F_DATASIZE', '数据大小', 8, 1, NULL, NULL, NULL, 4, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10005', 'F_DATAUNIT', '数据大小单位', 10, 200, NULL, NULL, NULL, 5, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10006', 'F_SRCDATAPATH', '源文件目录', 10, 500, NULL, NULL, NULL, 6, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10007', 'F_LOCATION', '目标文件目录', 10, 500, NULL, NULL, NULL, 7, '10000', 0, 0, NULL, NULL, 1);
INSERT INTO tbimg_field
(f_id, f_name, f_aliasname, f_fieldtype, f_length, f_defaultvalue, f_nullable, f_domainid, f_order, f_pid, f_isgroup, f_queryuitype, f_queryuiparams, f_desc, f_issysfield)
VALUES('10008', 'F_ISPUBLISH', '是否发布', 7, 1, NULL, NULL, NULL, 8, '10000', 0, 0, NULL, NULL, 1);
