--创建数据申请组
CREATE TABLE tbimg_apply_group
(
    f_id            varchar(32)  NOT NULL PRIMARY KEY,
    f_name          varchar(100) NOT NULL,
    f_desc          varchar(2000) NULL,
	f_data        text NULL,
	f_createuser varchar(255) NOT NULL,
	f_createtime timestamp(6) NOT NULL
);
COMMENT ON TABLE tbimg_apply_group IS '数据申请组';

COMMENT ON COLUMN tbimg_apply_group.f_id IS '主键';
COMMENT ON COLUMN tbimg_apply_group.f_name IS '名称';
COMMENT ON COLUMN tbimg_apply_group.f_desc IS '描述';
COMMENT ON COLUMN tbimg_apply_group.f_data IS '待申请的数据id，以逗号分隔';
COMMENT ON COLUMN tbimg_apply_group.f_createuser IS '创建人';
COMMENT ON COLUMN tbimg_apply_group.f_createtime IS '创建时间';

--创建数据申请订单
CREATE TABLE tbimg_order
(
    f_id            varchar(32)  NOT NULL PRIMARY KEY,
    f_name          varchar(100) NULL,
	f_desc          text NULL,
	f_number          varchar(100) NOT NULL,

	f_apply_purpose text NULL,
	f_apply_desc text NULL,

	 f_apply_userid varchar(255) NOT NULL,
	f_apply_username varchar(255) NOT NULL,
	f_apply_userunit varchar(255) NULL,

	f_approve_userid varchar(255)   NULL,
	f_approve_username varchar(255)   NULL,
	f_approve_opinion text  NULL,
	f_approve_desc text NULL,

	f_data  text   NOT    NULL,
	f_data_number int4 NOT NULL,
	f_data_size int4 NOT NULL,

	f_createtime timestamp(6) NOT NULL,
		f_applytime timestamp(6) NOT NULL,
	f_approvaltime timestamp(6)  NULL,

	f_status varchar(255) NULL,
	f_extraction_mode varchar(32) NULL,

	f_isdeleted int4 NULL
);
COMMENT ON TABLE tbimg_order IS '数据申请订单';

COMMENT ON COLUMN tbimg_order.f_id IS '主键';
COMMENT ON COLUMN tbimg_order.f_name IS '订单名称';
COMMENT ON COLUMN tbimg_order.f_desc IS '订单描述';
COMMENT ON COLUMN tbimg_order.f_number IS '订单编号';


COMMENT ON COLUMN tbimg_order.f_apply_purpose IS '数据用途';
COMMENT ON COLUMN tbimg_order.f_apply_desc IS '申请用户备注';


COMMENT ON COLUMN tbimg_order.f_apply_userid IS '申请用户id';
COMMENT ON COLUMN tbimg_order.f_apply_username IS '申请用户名';
COMMENT ON COLUMN tbimg_order.f_apply_userunit IS '申请用户单位';

COMMENT ON COLUMN tbimg_order.f_approve_userid IS '审批用户id';
COMMENT ON COLUMN tbimg_order.f_approve_username IS '审批用户名';
COMMENT ON COLUMN tbimg_order.f_approve_opinion IS '审批用户意见';
COMMENT ON COLUMN tbimg_order.f_approve_desc IS '审批用户备注';

COMMENT ON COLUMN tbimg_order.f_data IS '订单的数据id，以逗号分隔';
COMMENT ON COLUMN tbimg_order.f_data_number IS '订单的数据条数';
COMMENT ON COLUMN tbimg_order.f_data_size IS '订单的总数据量，以M为单位';



COMMENT ON COLUMN tbimg_order.f_createtime IS '创建时间';
COMMENT ON COLUMN tbimg_order.f_applytime IS '申请时间，用户订单被打回后，再次申请的，此时间会被更新，创建时间生成后不会再更改';
COMMENT ON COLUMN tbimg_order.f_approvaltime IS '审批时间';

COMMENT ON COLUMN tbimg_order.f_status IS '订单状态，0/null：待审批；1：未通过；2：已完成；3：已撤销';
COMMENT ON COLUMN tbimg_order.f_extraction_mode IS '提取方式，0：线下；1：线上';

COMMENT ON COLUMN tbimg_order.f_isdeleted IS '订单是否已删除，0/null：未删除，1：已删除';