/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.dataset;

import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.imagedb.dataset.dto.recycle.RecycleDataDeleteFilterDTO;
import com.geoway.imagedb.dataset.dto.recycle.RecycleDataFilterDTO;
import com.geoway.imagedb.dataset.service.ImgRecycleCatalogService;
import com.geoway.imagedb.dataset.service.impl.ImageDataEditServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle"})
@Api(tags={"01.03-\u56de\u6536\u7ad9"})
public class ImageRecycleController {
    @Resource
    private ImgRecycleCatalogService imgRecycleCatalogService;
    @Resource
    private ImageDataEditServiceImpl imageDataEditService;

    @ApiOperation(value="01-\u83b7\u53d6\u8d44\u6e90\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/catalog/tree"})
    public Response<ResCatalogNodeDTO> getCatalogTree(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.imgRecycleCatalogService.getCatalogTree(keyword));
    }

    @ApiOperation(value="02-\u67e5\u8be2\u56de\u6536\u7ad9\u7684\u5f71\u50cf\u6570\u636e")
    @GetMapping(value={"/query"})
    public Response<DataQueryResult> queryRecycleImageData(@RequestParam String datasetId, @RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows) {
        return Response.ok((Object)this.imgRecycleCatalogService.queryRecycleImageData(datasetId, pageIndex, rows));
    }

    @ApiOperation(value="03-\u5f7b\u5e95\u5220\u9664\u5f71\u50cf\u6570\u636e")
    @PostMapping(value={"/delete"})
    public Response deleteImageData(@RequestBody RecycleDataDeleteFilterDTO deleteFilterDTO) {
        this.imageDataEditService.deleteImageData(deleteFilterDTO.getDatasetId(), deleteFilterDTO.getObjectIdList(), deleteFilterDTO.getDeleteFile());
        return Response.ok();
    }

    @ApiOperation(value="04-\u6062\u590d\u5f71\u50cf\u6570\u636e")
    @PostMapping(value={"/restore"})
    public Response restoreImageData(@RequestBody RecycleDataFilterDTO filterDTO) {
        this.imageDataEditService.restoreImageData(filterDTO.getDatasetId(), filterDTO.getObjectIdList());
        return Response.ok();
    }
}

