--创建覆盖分析定时统计表
CREATE TABLE tbimg_coverageanalyse
(
    objectid            varchar(32) PRIMARY KEY,
    shape               geometry(geometry, 4490),
    f_name              varchar(1000) NOT NULL,
    f_group_name        varchar(1000) NOT NULL,
    f_group_id          varchar(32) NULL,
    f_data_count        int4          NOT NULL,
    f_data_size         int8          NOT NULL,
    f_display_data_size varchar(255)  NOT NULL,
    f_coverage_percent  float8 NULL,
    f_year              int4 NULL,
    f_time_group        int4 NULL,
    f_image_type        int4          NOT NULL
);
CREATE INDEX sidx_tbimg_coverageanalyse ON tbimg_coverageanalyse USING gist (shape);
COMMENT ON TABLE tbimg_coverageanalyse IS '覆盖分析定时统计';

COMMENT ON COLUMN tbimg_coverageanalyse.f_name IS '名称';
COMMENT ON COLUMN tbimg_coverageanalyse.f_group_name IS '分组名称';
COMMENT ON COLUMN tbimg_coverageanalyse.f_group_id IS '分组标识';
COMMENT ON COLUMN tbimg_coverageanalyse.f_data_count IS '数据数量';
COMMENT ON COLUMN tbimg_coverageanalyse.f_data_size IS '数据大小';
COMMENT ON COLUMN tbimg_coverageanalyse.f_display_data_size IS '自适应单位的数据大小';
COMMENT ON COLUMN tbimg_coverageanalyse.f_coverage_percent IS '覆盖率百分比';
COMMENT ON COLUMN tbimg_coverageanalyse.f_year IS '年度';
COMMENT ON COLUMN tbimg_coverageanalyse.f_time_group IS '时间组';
COMMENT ON COLUMN tbimg_coverageanalyse.f_image_type IS '影像类型';