/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.imagedb.apply.dto.satellite.GeometryProjectDTO;
import com.geoway.imagedb.apply.dto.satellite.ObjectIdListDTO;
import com.geoway.imagedb.apply.dto.satellite.SatelliteRequirementDTO;
import com.geoway.imagedb.apply.entity.ImgSatellite;
import com.geoway.imagedb.apply.service.ImgSatelliteService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/satellite/manage"})
@Api(tags={"01.04-\u536b\u661f\u7ba1\u7406"})
public class ImgSatelliteController {
    @Resource
    private ImgSatelliteService imgSatelliteService;

    @ApiOperation(value="01-\u83b7\u53d6\u536b\u661f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="resolutions", value="\u5206\u8fa8\u7387\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="countries", value="\u56fd\u5bb6\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="types", value="\u7c7b\u578b\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="is_initial_load", value="\u662f\u5426\u521d\u59cb\u52a0\u8f7d 0-\u5426 1-\u662f")})
    @GetMapping(value={"/list"})
    public Response<List<ImgSatellite>> list(@RequestParam(required=false) String keyword, @RequestParam(required=false) String resolutions, @RequestParam(required=false) String countries, @RequestParam(required=false) String types, @RequestParam(required=false) Integer is_initial_load) {
        return Response.ok((Object)this.imgSatelliteService.list(keyword, resolutions, countries, types, is_initial_load));
    }

    @ApiOperation(value="02-\u65b0\u589e/\u7f16\u8f91\u536b\u661f(id\u4e3a\u7a7a\u65f6\u65b0\u589e)")
    @PostMapping(value={"/add/edit"})
    public Response<String> addOrUpdate(@RequestBody ImgSatellite satellite) {
        return Response.ok((Object)this.imgSatelliteService.addOrUpdate(satellite));
    }

    @ApiOperation(value="03-\u5220\u9664\u536b\u661f")
    @DeleteMapping(value={"/delete"})
    public Response delete(@RequestParam String id) {
        this.imgSatelliteService.delete(id);
        return Response.ok();
    }

    @ApiOperation(value="04-\u5bfc\u5165\u536b\u661f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="json\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @PostMapping(value={"/import"})
    @UploadFileCheck(supportedSuffixes={".json"})
    public Response importSatellite(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.imgSatelliteService.importSatellite(file));
    }

    @ApiOperation(value="05-\u5bfc\u51fa\u536b\u661f")
    @GetMapping(value={"/export"})
    public void exportSatellite(@RequestParam String id) {
        this.imgSatelliteService.exportSatellite(id);
    }

    @ApiOperation(value="06-\u65b0\u589e\u9700\u6c42")
    @PostMapping(value={"/requirement/add"})
    public Response<Integer> addRequirement(@RequestBody List<SatelliteRequirementDTO> requirementList) {
        return Response.ok((Object)this.imgSatelliteService.addRequirement(requirementList));
    }

    @ApiOperation(value="07-\u67e5\u8be2\u9700\u6c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u9875\u7801"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u884c\u6570"), @ApiImplicitParam(name="requirementStartTime", value="\u9700\u6c42\u5f00\u59cb\u65f6\u95f4 \u683c\u5f0f(yyyy/MM/dd)", dataType="date"), @ApiImplicitParam(name="requirementEndTime", value="\u9700\u6c42\u7ed3\u675f\u65f6\u95f4 \u683c\u5f0f(yyyy/MM/dd)", dataType="date")})
    @GetMapping(value={"/requirement/query"})
    public Response<DataQueryResult> queryRequirement(@RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows, @RequestParam(required=false) Date requirementStartTime, @RequestParam(required=false) Date requirementEndTime) {
        return Response.ok((Object)this.imgSatelliteService.queryRequirement(pageIndex, rows, requirementStartTime, requirementEndTime));
    }

    @ApiOperation(value="08-\u67e5\u8be2\u9700\u6c42ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="requirementStartTime", value="\u9700\u6c42\u5f00\u59cb\u65f6\u95f4 \u683c\u5f0f(yyyy/MM/dd)", dataType="date"), @ApiImplicitParam(name="requirementEndTime", value="\u9700\u6c42\u7ed3\u675f\u65f6\u95f4 \u683c\u5f0f(yyyy/MM/dd)", dataType="date")})
    @GetMapping(value={"/requirement/query/ids"})
    public Response<List<String>> queryRequirementIds(@RequestParam(required=false) Date requirementStartTime, @RequestParam(required=false) Date requirementEndTime) {
        return Response.ok((Object)this.imgSatelliteService.queryRequirementIds(requirementStartTime, requirementEndTime));
    }

    @ApiOperation(value="09-\u5bfc\u51fa\u9700\u6c42")
    @PostMapping(value={"/requirement/export"})
    public void exportRequirementShp(@RequestBody ObjectIdListDTO idListDTO) {
        this.imgSatelliteService.exportRequirementShp(idListDTO.getIds());
    }

    @ApiOperation(value="10-\u5220\u9664\u9700\u6c42")
    @PostMapping(value={"/requirement/delete"})
    public Response<Long> deleteByIds(@RequestBody ObjectIdListDTO idListDTO) {
        return Response.ok((Object)this.imgSatelliteService.deleteByIds(idListDTO.getIds()));
    }

    @ApiOperation(value="11-\u5750\u6807\u8f6c\u6362")
    @PostMapping(value={"/coordinate/transformation"})
    public Response<String> projectGeometry(@RequestBody GeometryProjectDTO projectParam) {
        return Response.ok((Object)this.imgSatelliteService.projectGeometry(projectParam));
    }
}

